/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.monitoring;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.functionaltests.pages.admincenter.monitoring.MonitoringPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class LogsPage
extends MonitoringPage {
    public LogsPage(WebDriver driver) {
        super(driver);
    }

    public List<String> getServerLogFileNames() {
        List<WebElement> serverLogTabs = this.getServerLogTabs();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (WebElement element : serverLogTabs) {
            fileNames.add(element.getText());
        }
        return fileNames;
    }

    protected List<WebElement> getServerLogTabs() {
        return LogsPage.findElementsWithTimeout(By.xpath((String)"//div[@class='tabsBar subtabsBar']//li"));
    }

    public LogsPage selectServerLogFileTab(String serverLogFileName) {
        List<WebElement> serverLogTabs = this.getServerLogTabs();
        for (WebElement element : serverLogTabs) {
            if (!serverLogFileName.equals(element.getText())) continue;
            element.click();
        }
        return this.asPage(LogsPage.class);
    }

    public WebElement getDownloadButton(String serverLogFileName) {
        String downloadButtonValue = "Download " + serverLogFileName;
        return LogsPage.findElementWithTimeout(By.xpath((String)("//input[@value='" + downloadButtonValue + "']")));
    }
}

