/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import org.junit.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class TrashSubPage
extends AbstractPage {
    private static final String SELECT_ALL_BUTTON_ID = "document_trash_content:nxl_document_listing_table:listing_table_selection_box_with_current_document_header";
    private static final String PERMANENT_DELETE_BUTTON_ID = "document_trash_content_buttons:nxw_CURRENT_SELECTION_DELETE_form:nxw_CURRENT_SELECTION_DELETE";
    @Required
    @FindBy(id="cv_document_trash_content_0_resultsPanel")
    protected WebElement documentContentForm;

    public TrashSubPage(WebDriver driver) {
        super(driver);
    }

    public TrashSubPage purgeAllDocuments() {
        TrashSubPage page = this.asPage(TrashSubPage.class);
        By locator = By.id((String)SELECT_ALL_BUTTON_ID);
        if (!this.hasElement(locator)) {
            return page;
        }
        TrashSubPage.findElementWaitUntilEnabledAndClick(By.id((String)SELECT_ALL_BUTTON_ID));
        this.deleteSelectedDocuments();
        try {
            this.documentContentForm.findElement(By.tagName((String)"tbody"));
        }
        catch (NoSuchElementException e) {
            return page;
        }
        return this.purgeAllDocuments();
    }

    protected void deleteSelectedDocuments() {
        TrashSubPage.findElementWaitUntilEnabledAndClick(By.id((String)PERMANENT_DELETE_BUTTON_ID));
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Permanently delete selected document(s)?", (Object)alert.getText());
        alert.accept();
    }
}

