/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import com.google.common.base.Function;
import java.util.concurrent.TimeUnit;
import org.nuxeo.functionaltests.AbstractTest;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

public class JSListRequestManager {
    protected JavascriptExecutor js;
    protected boolean active;
    protected int count;

    public JSListRequestManager(WebDriver driver) {
        this.js = (JavascriptExecutor)driver;
        this.reset();
    }

    protected void reset() {
        this.active = false;
        this.count = 0;
    }

    public void begin() {
        StringBuilder sb = new StringBuilder();
        sb.append("if (window.NuxeoTestJsList === undefined) {");
        sb.append("  window.NuxeoTestJsList = function() {");
        sb.append("    var e = {};");
        sb.append("    e.jsRequestStarted = false;");
        sb.append("    e.jsRequestFinished = false;");
        sb.append("    e.jsRequestActiveCount = 0;");
        sb.append("    e.increment = function() {");
        sb.append("      e.jsRequestStarted = true;");
        sb.append("      e.jsRequestFinished = false;");
        sb.append("      e.jsRequestActiveCount++;");
        sb.append("    };");
        sb.append("    e.decrement = function() {");
        sb.append("      e.jsRequestActiveCount--;");
        sb.append("      if (e.jsRequestActiveCount == 0) {");
        sb.append("        e.jsRequestFinished = true;");
        sb.append("      }");
        sb.append("    };");
        sb.append("    e.finished = function() {");
        sb.append("      return e.jsRequestStarted && e.jsRequestFinished;");
        sb.append("    };");
        sb.append("   return e");
        sb.append("  }();");
        sb.append("}");
        sb.append("  nuxeo.utils.addOnEvent(function(data) {");
        sb.append("    if (data.status == 'begin') {window.NuxeoTestJsList.increment();}");
        sb.append("    if (data.status == 'success') {window.NuxeoTestJsList.decrement();}");
        sb.append("  });");
        this.js.executeScript(sb.toString(), new Object[0]);
    }

    public void end() {
        this.waitUntil(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                Boolean res = (Boolean)JSListRequestManager.this.js.executeScript("return window.NuxeoTestJsList.finished();", new Object[0]);
                return res;
            }
        });
    }

    private void waitUntil(Function<WebDriver, Boolean> function) {
        FluentWait wait = new FluentWait((Object)AbstractTest.driver).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class);
        wait.until(function);
    }
}

