/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import com.google.common.base.Function;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AddToCollectionForm
extends WebFragmentImpl {
    private static final String ADD_ALL_BUTTON_ID = "document_content_buttons:nxw_cvButton_addSelectedToCollectionAction_fancy_subview:nxw_cvButton_addSelectedToCollectionAction_fancyform:addAll";
    private static final String ADD_BUTTON_ID = "nxw_documentActionsUpperButtons_addToCollectionAction_fancy_subview:nxw_documentActionsUpperButtons_addToCollectionAction_fancyform:add";
    private static final String S2_CHOOSE_COLLECTION_ID = "s2id_nxw_documentActionsUpperButtons_addToCollectionAction_fancy_subview:nxw_documentActionsUpperButtons_addToCollectionAction_fancyform:nxw_singleDocumentSuggestion_1_select2";
    private static final String S2_CHOOSE_COLLECTION_MULTIPLE_ID = "s2id_document_content_buttons:nxw_cvButton_addSelectedToCollectionAction_fancy_subview:nxw_cvButton_addSelectedToCollectionAction_fancyform:nxw_singleDocumentSuggestion_2_select2";
    private static final String NEW_COLLECTION_DESCRIPTION_ID = "nxw_documentActionsUpperButtons_addToCollectionAction_fancy_subview:nxw_documentActionsUpperButtons_addToCollectionAction_fancyform:description";
    private static final String NEW_COLLECTION_DESCRIPTION_MULTIPLE_ID = "document_content_buttons:nxw_cvButton_addSelectedToCollectionAction_fancy_subview:nxw_cvButton_addSelectedToCollectionAction_fancyform:nxw_cvButton_addSelectedToCollectionAction_fancyform_collectionDescriptionsPanel";
    private static final String EXISTING_COLLECTION_DESCRIPTION_ID = "nxw_documentActionsUpperButtons_addToCollectionAction_fancy_subview:nxw_documentActionsUpperButtons_addToCollectionAction_fancyform:scd";
    private static final String EXISTING_COLLECTION_DESCRIPTION_MULTIPLE_ID = "document_content_buttons:nxw_cvButton_addSelectedToCollectionAction_fancy_subview:nxw_cvButton_addSelectedToCollectionAction_fancyform:scd";
    private boolean multiple = false;

    public AddToCollectionForm(WebDriver driver, WebElement element) {
        super(driver, element);
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    driver.findElement(By.id((String)AddToCollectionForm.ADD_BUTTON_ID));
                    AddToCollectionForm.this.multiple = false;
                    return true;
                }
                catch (NoSuchElementException e) {
                    driver.findElement(By.id((String)AddToCollectionForm.ADD_ALL_BUTTON_ID));
                    AddToCollectionForm.this.multiple = true;
                    return true;
                }
            }
        }, NoSuchElementException.class);
    }

    public DocumentBasePage add() {
        return this.add(DocumentBasePage.class);
    }

    public <T> T add(Class<T> pageClassProxy) {
        Locator.findElementWaitUntilEnabledAndClick(By.id((String)ADD_BUTTON_ID));
        return AbstractTest.asPage(pageClassProxy);
    }

    public DocumentBasePage addAll() {
        return this.addAll(DocumentBasePage.class);
    }

    public <T> T addAll(Class<T> pageClassProxy) {
        Locator.findElementWaitUntilEnabledAndClick(By.id((String)ADD_ALL_BUTTON_ID));
        return AbstractTest.asPage(pageClassProxy);
    }

    public void setCollection(String collectionName) {
        Select2WidgetElement s2Collection = new Select2WidgetElement(this.driver, Locator.findElementWithTimeout(By.id((String)(this.multiple ? S2_CHOOSE_COLLECTION_MULTIPLE_ID : S2_CHOOSE_COLLECTION_ID)), this.getElement()), false);
        s2Collection.selectValue(collectionName);
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return StringUtils.isBlank((String)driver.findElement(By.id((String)(AddToCollectionForm.this.multiple ? AddToCollectionForm.ADD_ALL_BUTTON_ID : AddToCollectionForm.ADD_BUTTON_ID))).getAttribute("disabled"));
            }
        }, StaleElementReferenceException.class);
    }

    public void setNewDescription(String collectionDescription) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Locator.findElementWithTimeout(By.id((String)(this.multiple ? NEW_COLLECTION_DESCRIPTION_MULTIPLE_ID : NEW_COLLECTION_DESCRIPTION_ID))).sendKeys(new CharSequence[]{collectionDescription});
    }

    public boolean isNewDescriptionVisible() {
        try {
            this.driver.findElement(By.id((String)(this.multiple ? NEW_COLLECTION_DESCRIPTION_MULTIPLE_ID : NEW_COLLECTION_DESCRIPTION_ID)));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isExistingDescriptionVisible() {
        try {
            this.driver.findElement(By.id((String)(this.multiple ? EXISTING_COLLECTION_DESCRIPTION_MULTIPLE_ID : EXISTING_COLLECTION_DESCRIPTION_ID)));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String getExistingDescription() {
        return this.driver.findElement(By.id((String)(this.multiple ? EXISTING_COLLECTION_DESCRIPTION_MULTIPLE_ID : EXISTING_COLLECTION_DESCRIPTION_ID))).getText();
    }

    public void removeDocumentToBeAddedToCollection(int index) {
        if (!this.multiple) {
            throw new UnsupportedOperationException("You are not adding many documents to the collection");
        }
        List docsToBeAdded = this.getElement().findElements(By.xpath((String)"//div[@class='simpleBox']"));
        final int docsToBeAddedSize = docsToBeAdded.size();
        ((WebElement)docsToBeAdded.get(index)).findElement(By.xpath((String)"a")).click();
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return AddToCollectionForm.this.getElement().findElements(By.xpath((String)"//div[@class='simpleBox']")).size() == docsToBeAddedSize - 1;
            }
        }, StaleElementReferenceException.class);
    }
}

