/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.io.IOException;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.forms.AbstractWidgetElement;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class FileWidgetElement
extends AbstractWidgetElement {
    public FileWidgetElement(WebDriver driver, String id) {
        super(driver, id);
    }

    public String getEditChoice() {
        for (InputFileChoice choice : InputFileChoice.values()) {
            String subid = "choice" + choice.name();
            if (!this.hasSubElement(subid) || !this.getSubElement(subid).isSelected()) continue;
            return choice.name();
        }
        return null;
    }

    public String getFilename(boolean isEdit) {
        WebElement link = isEdit ? this.getSubElement("default_download:download") : this.getSubElement("download");
        return link.getText();
    }

    public void uploadTestFile(String prefix, String suffix, String content) throws IOException {
        String fileToUploadPath = AbstractTest.getTmpFileToUploadPath(prefix, suffix, content);
        WebElement upRadioButton = this.getSubElement("choiceupload");
        upRadioButton.click();
        WebElement fileInput = this.getSubElement("upload");
        fileInput.sendKeys(new CharSequence[]{fileToUploadPath});
    }

    public void removeFile() {
        if (this.hasSubElement("choicenone")) {
            WebElement delRadioButton = this.getSubElement("choicenone");
            delRadioButton.click();
        } else if (this.hasSubElement("choicedelete")) {
            WebElement delRadioButton = this.getSubElement("choicedelete");
            delRadioButton.click();
        } else {
            throw new NoSuchElementException("No delete choice available on widget");
        }
    }

    static enum InputFileChoice {
        none,
        keep,
        upload,
        delete,
        tempKeep;

    }
}

