/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.util.List;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.forms.AbstractWidgetElement;
import org.nuxeo.functionaltests.forms.JSListWidgetElement;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ListWidgetElement
extends AbstractWidgetElement {
    private final JSListWidgetElement.Display display;

    public ListWidgetElement(WebDriver driver, String id) {
        this(driver, id, JSListWidgetElement.Display.BLOCK_LEFT);
    }

    public ListWidgetElement(WebDriver driver, String id, JSListWidgetElement.Display display) {
        super(driver, id);
        this.display = display;
    }

    public String getListElementId() {
        return String.format("%s_input", this.getWidgetId());
    }

    protected String getListSubElementId(String subId, int index) {
        return String.format("%s:%s:%s", this.getListElementId(), index, subId);
    }

    protected String getListSubElementSuffix(String subId, int index) {
        return String.format("%s:%s:%s", this.getListElementId(), index, subId);
    }

    public void addNewElement() {
        String wid = this.getWidgetId();
        WebElement addElement = this.getSubElement(wid + "_add");
        AjaxRequestManager arm = new AjaxRequestManager((WebDriver)AbstractTest.driver);
        arm.begin();
        addElement.click();
        arm.end();
    }

    public void removeElement(int index) {
        String wid = this.getWidgetId();
        String delId = String.format("%s:%s:%s_delete", this.getListElementId(), index, wid);
        WebElement delElement = this.getSubElement(delId);
        AjaxRequestManager arm = new AjaxRequestManager((WebDriver)AbstractTest.driver);
        arm.begin();
        delElement.click();
        arm.end();
    }

    public void moveUpElement(int index) {
        WebElement moveElement = this.getRowActions(index).findElement(By.className((String)"moveUpBtn"));
        AjaxRequestManager arm = new AjaxRequestManager((WebDriver)AbstractTest.driver);
        arm.begin();
        moveElement.click();
        arm.end();
    }

    public void moveDownElement(int index) {
        WebElement moveElement = this.getRowActions(index).findElement(By.className((String)"moveDownBtn"));
        AjaxRequestManager arm = new AjaxRequestManager((WebDriver)AbstractTest.driver);
        arm.begin();
        moveElement.click();
        arm.end();
    }

    public void waitForSubWidget(String id, int index) {
        this.getSubElement(this.getListSubElementId(id, index), true);
    }

    public WidgetElement getSubWidget(String id, int index) {
        return this.getSubWidget(id, index, false);
    }

    public WidgetElement getSubWidget(String id, int index, boolean wait) {
        if (wait) {
            this.waitForSubWidget(id, index);
        }
        return this.getWidget(this.getListSubElementId(id, index));
    }

    public <T> T getSubWidget(String id, int index, Class<T> widgetClassToProxy, boolean wait) {
        if (wait) {
            this.waitForSubWidget(id, index);
        }
        return this.getWidget(this.getListSubElementId(id, index), widgetClassToProxy);
    }

    @Override
    public String getMessageValue() {
        return this.getMessageValue(":" + this.getWidgetId() + "_message");
    }

    public List<WebElement> getRows() {
        return this.driver.findElements(By.cssSelector((String)this.getRowsCssSelector()));
    }

    private String getElementCssSelector() {
        return "#" + this.getId().replaceAll(":", "\\\\:") + "\\:" + this.getWidgetId() + "_panel";
    }

    private String getRowsCssSelector() {
        String path = this.getElementCssSelector();
        if (this.display == JSListWidgetElement.Display.TABLE || this.display == JSListWidgetElement.Display.INLINE) {
            path = path + " > table > tbody";
        }
        return path + " > .listItem";
    }

    protected WebElement getRowActions(int i) {
        if (this.display == JSListWidgetElement.Display.TABLE || this.display == JSListWidgetElement.Display.INLINE) {
            return this.driver.findElement(By.cssSelector((String)(this.getRowCssSelector(i) + " > .listWidgetActions")));
        }
        return this.getSubElement(this.getListSubElementSuffix(this.getWidgetId() + "_actions", i));
    }

    private String getRowCssSelector(int i) {
        return this.getRowsCssSelector() + ":nth-of-type(" + (i + 1) + ")";
    }

    public String getSubWidgetMessageValue(String id, int idx) {
        return this.getSubWidgetMessageValue(id, idx, 0);
    }

    public String getSubWidgetMessageValue(String id, int idx, int msgIdx) {
        String subId = id + "_message";
        if (msgIdx != 0) {
            subId = subId + "_" + msgIdx;
        }
        return this.getMessageValue(":" + this.getListSubElementSuffix(subId, idx));
    }
}

