/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.fragment;

import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.fragment.WebFragment;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebFragmentImpl
implements WebFragment {
    protected final WebDriver driver;
    protected String id;
    protected WebElement element;

    public WebFragmentImpl(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
        this.id = element.getAttribute("id");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public WebElement getElement() {
        return this.element;
    }

    @Override
    public void setElement(WebElement element) {
        this.element = element;
        this.id = element.getAttribute("id");
    }

    @Override
    public void click() {
        this.element.click();
    }

    @Override
    public void submit() {
        this.element.submit();
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        this.element.sendKeys(keysToSend);
    }

    @Override
    public void clear() {
        this.element.clear();
    }

    @Override
    public String getTagName() {
        return this.element.getTagName();
    }

    @Override
    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    @Override
    public boolean isSelected() {
        return this.element.isSelected();
    }

    @Override
    public boolean isEnabled() {
        return this.element.isEnabled();
    }

    @Override
    public String getText() {
        return this.element.getText();
    }

    @Override
    public List<WebElement> findElements(By by) {
        return this.element.findElements(by);
    }

    @Override
    public WebElement findElement(By by) {
        return this.element.findElement(by);
    }

    @Override
    public boolean isDisplayed() {
        return this.element.isDisplayed();
    }

    @Override
    public Point getLocation() {
        return this.element.getLocation();
    }

    @Override
    public Dimension getSize() {
        return this.element.getSize();
    }

    @Override
    public String getCssValue(String propertyName) {
        return this.element.getCssValue(propertyName);
    }

    @Override
    public <T extends WebFragment> T getWebFragment(By by, Class<T> webFragmentClass) {
        return AbstractTest.getWebFragment(by, webFragmentClass);
    }

    @Override
    public <T extends WebFragment> T getWebFragment(WebElement element, Class<T> webFragmentClass) {
        return AbstractTest.getWebFragment(element, webFragmentClass);
    }

    @Override
    public boolean containsText(String text) {
        return this.element.getText().contains(text);
    }

    @Override
    public void waitForTextToBePresent(String text) {
        Locator.waitForTextPresent(this.element, text);
    }

    @Override
    public void checkTextToBePresent(String text) {
        Assert.assertTrue((boolean)this.element.getText().contains(text));
    }

    @Override
    public void checkTextToBeNotPresent(String text) {
        Assert.assertFalse((boolean)this.element.getText().contains(text));
    }
}

