/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.usermanagement;

import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UserCreationFormPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UserViewTabSubPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class UsersTabSubPage
extends UsersGroupsBasePage {
    @Required
    @FindBy(id="usersListingView:createUserActionsForm:createUserButton")
    WebElement createNewUserLink;
    @FindBy(id="usersListingView:searchForm:searchText")
    WebElement searchInput;
    @FindBy(id="usersListingView:searchForm:searchButton")
    WebElement searchButton;

    public UsersTabSubPage(WebDriver driver) {
        super(driver);
    }

    public UserCreationFormPage getUserCreatePage() {
        this.createNewUserLink.click();
        return this.asPage(UserCreationFormPage.class);
    }

    public UsersTabSubPage searchUser(String query) {
        this.searchInput.clear();
        this.searchInput.sendKeys(new CharSequence[]{query});
        this.searchButton.submit();
        return this.asPage(UsersTabSubPage.class);
    }

    public boolean isUserFound(String username) {
        try {
            this.findElementWithTimeout(By.linkText((String)username), 2000);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public UserViewTabSubPage viewUser(String username) {
        UsersTabSubPage.findElementWithTimeout(By.linkText((String)username)).click();
        return this.asPage(UserViewTabSubPage.class);
    }
}

