/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.search;

import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.search.DefaultSearchSubPage;
import org.nuxeo.functionaltests.pages.search.NXQLSearchSubPage;
import org.nuxeo.functionaltests.pages.search.QuickSearchSubPage;
import org.nuxeo.functionaltests.pages.search.SearchResultsSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class SearchPage
extends DocumentBasePage {
    public static final String SEARCH_TAB = "SEARCH";
    public static final String DEFAULT_SEARCH = "Default search";
    public static final String NXQL_SEARCH = "NXQL Search";
    public static final String QUICK_SEARCH = "Quick search";
    private static final String S2_SEARCH_TYPE_ID = "s2id_nxl_gridSearchLayout:nxw_searchesSelector_form:nxw_searchesSelector";
    @FindBy(id="nxl_gridSearchLayout:nxw_searchForm_panel")
    @Required
    protected WebElement searchFormPanel;
    @FindBy(id="nxl_gridSearchLayout:nxw_searchResults_panel")
    @Required
    protected WebElement searchResultPanel;

    public SearchPage(WebDriver driver) {
        super(driver);
    }

    public DefaultSearchSubPage getDefaultSearch() {
        if (!this.isDefaultSearch()) {
            this.selectSearch(DEFAULT_SEARCH);
        }
        return this.asPage(DefaultSearchSubPage.class);
    }

    public NXQLSearchSubPage getNXQLSearch() {
        if (!this.isNXQLSearch()) {
            this.selectSearch(NXQL_SEARCH);
        }
        return this.asPage(NXQLSearchSubPage.class);
    }

    public QuickSearchSubPage getQuickSearch() {
        if (!this.isQuickSearch()) {
            this.selectSearch(QUICK_SEARCH);
        }
        return this.asPage(QuickSearchSubPage.class);
    }

    public SearchResultsSubPage getSearchResultsSubPage() {
        return this.asPage(SearchResultsSubPage.class);
    }

    public boolean isDefaultSearch() {
        return this.isSearchSelected(DEFAULT_SEARCH);
    }

    public boolean isNXQLSearch() {
        return this.isSearchSelected(NXQL_SEARCH);
    }

    public boolean isQuickSearch() {
        return this.isSearchSelected(QUICK_SEARCH);
    }

    public void selectSearch(String searchLabel) {
        Select2WidgetElement s2 = new Select2WidgetElement(this.driver, this.searchFormPanel.findElement(By.id((String)S2_SEARCH_TYPE_ID)));
        AjaxRequestManager am = new AjaxRequestManager(this.driver);
        am.watchAjaxRequests();
        s2.selectValue(searchLabel);
        am.waitForAjaxRequests();
    }

    public String getSelectedSearch() {
        Select2WidgetElement s2 = new Select2WidgetElement(this.driver, this.searchFormPanel.findElement(By.id((String)S2_SEARCH_TYPE_ID)));
        return s2.getSelectedValue().getText();
    }

    protected boolean isSearchSelected(String searchType) {
        String selected = this.getSelectedSearch();
        return selected != null && selected.equals(searchType);
    }
}

