/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ContentTabSubPage
extends DocumentBasePage {
    private static final String COPY_BUTTON_XPATH = "//input[@value=\"Copy\"]";
    private static final String PASTE_BUTTON_XPATH = "//input[@value=\"Paste\"]";
    private static final String DELETE_BUTTON_XPATH = "//input[@value=\"Delete\"]";
    private static final String ADD_TO_WORKLIST_BUTTON_XPATH = "//input[@value=\"Add to worklist\"]";
    private static final String SELECT_ALL_BUTTON_XPATH = "//input[@type=\"checkbox\" and @title=\"Select all / deselect all\"]";
    private static final String CHECK_BOX_XPATH = "td/input[@type=\"checkbox\"]";
    private static final String DOCUMENT_TITLE_XPATH = "td//span[@id[starts-with(.,'title_')]]";
    @Required
    @FindBy(id="document_content")
    WebElement documentContentForm;
    @FindBy(linkText="New")
    WebElement newButton;
    @FindBy(id="cv_document_content_0_quickFilterForm:nxl_document_content_filter:nxw_search_title")
    WebElement filterInput;
    @FindBy(id="cv_document_content_0_quickFilterForm:submitFilter")
    WebElement filterButton;
    @FindBy(id="cv_document_content_0_resetFilterForm:resetFilter")
    WebElement clearFilterButton;
    @FindBy(xpath="//form[@id=\"document_content\"]//tbody//tr")
    List<WebElement> childDocumentRows;

    public List<WebElement> getChildDocumentRows() {
        return this.childDocumentRows;
    }

    public ContentTabSubPage(WebDriver driver) {
        super(driver);
    }

    public DocumentBasePage goToDocument(String documentTitle) {
        this.documentContentForm.findElement(By.linkText((String)documentTitle)).click();
        return this.asPage(DocumentBasePage.class);
    }

    public <T> T getDocumentCreatePage(String docType, Class<T> pageClassToProxy) {
        this.newButton.click();
        WebElement fancyBox = this.getFancyBoxContent();
        WebElement link = fancyBox.findElement(By.linkText((String)docType));
        Assert.assertNotNull((Object)link);
        link.click();
        return this.asPage(pageClassToProxy);
    }

    public DocumentBasePage removeDocument(String documentTitle) {
        List trelements = this.documentContentForm.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        for (WebElement trItem : trelements) {
            try {
                trItem.findElement(By.linkText((String)documentTitle));
                WebElement checkBox = trItem.findElement(By.xpath((String)CHECK_BOX_XPATH));
                checkBox.click();
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        this.deleteSelectedDocuments();
        return this.asPage(DocumentBasePage.class);
    }

    protected void deleteSelectedDocuments() {
        ContentTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)DELETE_BUTTON_XPATH));
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Delete selected document(s)?", (Object)alert.getText());
        alert.accept();
    }

    public DocumentBasePage addToWorkList(String documentTitle) {
        this.selectDocumentByTitles(documentTitle);
        ContentTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)ADD_TO_WORKLIST_BUTTON_XPATH));
        return this.asPage(DocumentBasePage.class);
    }

    public ContentTabSubPage removeAllDocuments() {
        ContentTabSubPage page = this.asPage(ContentTabSubPage.class);
        By locator = By.xpath((String)SELECT_ALL_BUTTON_XPATH);
        if (!this.hasElement(locator)) {
            return page;
        }
        ContentTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)SELECT_ALL_BUTTON_XPATH));
        this.deleteSelectedDocuments();
        try {
            this.documentContentForm.findElement(By.tagName((String)"tbody"));
        }
        catch (NoSuchElementException e) {
            return page;
        }
        return this.removeAllDocuments();
    }

    public void filterDocument(String filter, final int expectedNbOfDisplayedResult, int timeout) {
        this.filterInput.clear();
        this.filterInput.sendKeys(new CharSequence[]{filter});
        this.filterButton.click();
        Locator.waitUntilGivenFunction(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return ContentTabSubPage.this.getChildDocumentRows().size() == expectedNbOfDisplayedResult;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
        });
    }

    public void clearFilter(final int expectedNbOfDisplayedResult, int timeout) {
        this.clearFilterButton.click();
        Locator.waitUntilGivenFunction(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return ContentTabSubPage.this.getChildDocumentRows().size() == expectedNbOfDisplayedResult;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
        });
    }

    public void selectDocumentByIndex(int ... indexes) {
        AjaxRequestManager a = new AjaxRequestManager(this.driver);
        for (int i : indexes) {
            a.watchAjaxRequests();
            this.getChildDocumentRows().get(i).findElement(By.xpath((String)CHECK_BOX_XPATH)).click();
            a.waitForAjaxRequests();
        }
    }

    public void selectDocumentByTitles(String ... titles) {
        this.selectDocumentByIndex(this.convertToIndexes(titles));
    }

    protected int[] convertToIndexes(String ... titles) {
        List<String> titleList = Arrays.asList(titles);
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int index = 0;
        for (WebElement row : this.childDocumentRows) {
            String docTitle = row.findElement(By.xpath((String)DOCUMENT_TITLE_XPATH)).getText();
            if (docTitle != null && titleList.contains(docTitle)) {
                temp.add(index);
            }
            ++index;
        }
        int[] result = new int[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            result[i] = (Integer)temp.get(i);
        }
        return result;
    }

    public void copyByIndex(int ... indexes) {
        this.selectDocumentByIndex(indexes);
        ContentTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)COPY_BUTTON_XPATH));
    }

    public void copyByTitle(String ... titles) {
        this.copyByIndex(this.convertToIndexes(titles));
    }

    public ContentTabSubPage paste() {
        ContentTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)PASTE_BUTTON_XPATH));
        return this.asPage(ContentTabSubPage.class);
    }

    public DocumentBasePage goToDocument(int index) {
        this.getChildDocumentRows().get(index).findElement(By.xpath((String)"td[3]/div/a[1]")).click();
        return this.asPage(DocumentBasePage.class);
    }
}

