/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.base;

import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class ImporterRunnerConfiguration {
    public final SourceNode sourceNode;
    public final String importWritePath;
    public final boolean skipRootContainerCreation;
    public final int batchSize;
    public final int nbThreads;
    public final String jobName;
    public final ImporterLogger log;

    protected ImporterRunnerConfiguration(SourceNode sourceNode, String importWritePath, ImporterLogger log, boolean skipRootContainerCreation, int batchSize, int nbThreads, String jobName) {
        this.sourceNode = sourceNode;
        this.importWritePath = importWritePath;
        this.log = log;
        this.skipRootContainerCreation = skipRootContainerCreation;
        this.batchSize = batchSize;
        this.nbThreads = nbThreads;
        this.jobName = jobName;
    }

    public static class Builder {
        private SourceNode sourceNode;
        private String importWritePath;
        private ImporterLogger log;
        private boolean skipRootContainerCreation = false;
        private int batchSize = 50;
        private int nbThreads = 5;
        private String jobName;

        public Builder(SourceNode sourceNode, String importWritePath, ImporterLogger log) {
            this.sourceNode = sourceNode;
            this.importWritePath = importWritePath;
            this.log = log;
        }

        public Builder skipRootContainerCreation(Boolean skipRootContainerCreation) {
            if (skipRootContainerCreation != null) {
                this.skipRootContainerCreation = skipRootContainerCreation;
            }
            return this;
        }

        public Builder batchSize(Integer batchSize) {
            if (batchSize != null) {
                this.batchSize = batchSize;
            }
            return this;
        }

        public Builder nbThreads(Integer nbThreads) {
            if (nbThreads != null) {
                this.nbThreads = nbThreads;
            }
            return this;
        }

        public Builder jobName(String jobName) {
            if (jobName != null) {
                this.jobName = jobName;
            }
            return this;
        }

        public ImporterRunnerConfiguration build() {
            return new ImporterRunnerConfiguration(this.sourceNode, this.importWritePath, this.log, this.skipRootContainerCreation, this.batchSize, this.nbThreads, this.jobName);
        }
    }
}

