/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.runtime.api.Framework;

public class VideoHelper {
    public static final Log log = LogFactory.getLog(VideoHelper.class);
    public static final String MISSING_PREVIEW_PICTURE = "preview/missing-video-preview.jpeg";
    public static final String FFMPEG_INFO_COMMAND_LINE = "ffmpeg-info";
    public static final ArrayList<Map<String, Object>> THUMBNAILS_VIEWS = new ArrayList();

    private VideoHelper() {
    }

    public static void updateStoryboard(DocumentModel docModel, Blob video) throws PropertyException, ClientException {
        BlobHolder result;
        if (video == null) {
            docModel.setPropertyValue("vid:storyboard", null);
            docModel.setPropertyValue("vid:info/duration", null);
            return;
        }
        try {
            VideoDocument videoDocument = (VideoDocument)docModel.getAdapter(VideoDocument.class);
            HashMap<String, Double> parameters = new HashMap<String, Double>();
            parameters.put("duration", videoDocument.getVideo().getDuration());
            result = ((ConversionService)Framework.getService(ConversionService.class)).convert("videoStoryboard", (BlobHolder)new SimpleBlobHolder(video), parameters);
        }
        catch (ConversionException e) {
            log.warn((Object)String.format("could not process document '%s' with video file '%s': %s", docModel.getTitle(), video.getFilename(), e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
        List blobs = result.getBlobs();
        List comments = (List)((Object)result.getProperty("comments"));
        List timecodes = (List)((Object)result.getProperty("timecodes"));
        ArrayList storyboard = new ArrayList();
        for (int i = 0; i < blobs.size(); ++i) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("comment", comments.get(i));
            item.put("timecode", timecodes.get(i));
            item.put("content", (Serializable)blobs.get(i));
            storyboard.add(item);
        }
        docModel.setPropertyValue("vid:storyboard", (Serializable)storyboard);
    }

    public static void updatePreviews(DocumentModel docModel, Blob video, Double position, List<Map<String, Object>> templates) throws ClientException, IOException {
        BlobHolder result;
        if (video == null) {
            docModel.setPropertyValue("picture:views", null);
            return;
        }
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("position", position);
        try {
            result = ((ConversionService)Framework.getService(ConversionService.class)).convert("videoScreenshot", (BlobHolder)new SimpleBlobHolder(video), parameters);
        }
        catch (ConversionException e) {
            log.warn((Object)String.format("could not process document '%s' with video file '%s': %s", docModel.getTitle(), video.getFilename(), e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
        if (result != null && result.getBlob() != null && result.getBlob().getLength() > 0L) {
            PictureResourceAdapter picture = (PictureResourceAdapter)docModel.getAdapter(PictureResourceAdapter.class);
            try {
                picture.createPicture(result.getBlob(), result.getBlob().getFilename(), docModel.getTitle(), new ArrayList<Map<String, Object>>(templates));
            }
            catch (Exception e) {
                log.warn((Object)("failed to video compute previews for " + docModel.getTitle() + ": " + e.getMessage()));
            }
        }
        if (((List)docModel.getProperty("picture:views").getValue(List.class)).isEmpty()) {
            InputStream is = VideoHelper.class.getResourceAsStream("/preview/missing-video-preview.jpeg");
            Blob blob = StreamingBlob.createFromStream((InputStream)is, (String)"image/jpeg").persist();
            blob.setFilename(MISSING_PREVIEW_PICTURE.replace('/', '-'));
            PictureResourceAdapter picture = (PictureResourceAdapter)docModel.getAdapter(PictureResourceAdapter.class);
            picture.createPicture(blob, blob.getFilename(), docModel.getTitle(), new ArrayList<Map<String, Object>>(templates));
        }
    }

    public static void updatePreviews(DocumentModel docModel, Blob video) throws ClientException, IOException {
        Double duration = (Double)docModel.getPropertyValue("vid:info/duration");
        Double position = 0.0;
        if (duration != null) {
            position = duration * 0.1;
        }
        VideoHelper.updatePreviews(docModel, video, position, THUMBNAILS_VIEWS);
    }

    public static void updateVideoInfo(DocumentModel docModel, Blob video) throws ClientException {
        VideoInfo videoInfo = VideoHelper.getVideoInfo(video);
        if (videoInfo == null) {
            docModel.setPropertyValue("vid:info", (Serializable)((Object)VideoInfo.EMPTY_INFO.toMap()));
            return;
        }
        docModel.setPropertyValue("vid:info", (Serializable)((Object)videoInfo.toMap()));
    }

    public static VideoInfo getVideoInfo(Blob video) throws ClientException {
        if (video == null) {
            return null;
        }
        File file = null;
        try {
            CommandLineExecutorService cleService = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            file = File.createTempFile("ffmpegInfo", "." + FilenameUtils.getExtension((String)video.getFilename()));
            video.transferTo(file);
            CmdParameters params = new CmdParameters();
            params.addNamedParameter("inFilePath", file.getAbsolutePath());
            ExecResult result = cleService.execCommand(FFMPEG_INFO_COMMAND_LINE, params);
            VideoInfo videoInfo = VideoInfo.fromFFmpegOutput((List)result.getOutput());
            return videoInfo;
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    static {
        LinkedHashMap<String, Object> thumbnailView = new LinkedHashMap<String, Object>();
        thumbnailView.put("title", "Thumbnail");
        thumbnailView.put("maxsize", 100L);
        THUMBNAILS_VIEWS.add(thumbnailView);
        HashMap<String, Object> staticPlayerView = new HashMap<String, Object>();
        staticPlayerView.put("title", "StaticPlayerView");
        staticPlayerView.put("maxsize", 550L);
        THUMBNAILS_VIEWS.add(staticPlayerView);
    }
}

