/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.listener;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;

public class VideoAutomaticConversionListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        if (!events.containsEventName("documentCreated") && !events.containsEventName("documentModified")) {
            return;
        }
        for (Event event : events) {
            if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName())) continue;
            this.handleEvent(event);
        }
    }

    private void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc == null || !doc.hasFacet("Video") || !ctx.hasProperty("videoChanged")) {
            return;
        }
        VideoService videoService = (VideoService)Framework.getLocalService(VideoService.class);
        videoService.launchAutomaticConversions(doc);
    }
}

