/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.importer.core;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.dam.core.service.InheritedPropertiesDescriptor;
import org.nuxeo.dam.core.service.InheritedPropertiesService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.importer.properties.MetadataFile;
import org.nuxeo.runtime.api.Framework;

public class MetadataFileHelper {
    private static final Log log = LogFactory.getLog(MetadataFileHelper.class);
    protected static InheritedPropertiesService inheritedPropertiesService;

    private MetadataFileHelper() {
    }

    protected static InheritedPropertiesService getInheritedPropertiesService() {
        if (inheritedPropertiesService == null) {
            try {
                inheritedPropertiesService = (InheritedPropertiesService)Framework.getService(InheritedPropertiesService.class);
            }
            catch (Exception e) {
                log.error((Object)"Unable to retrieve InheritedPropertiesService", (Throwable)e);
            }
        }
        return inheritedPropertiesService;
    }

    public static MetadataFile createFrom(DocumentModel doc) throws ClientException {
        InheritedPropertiesService service = MetadataFileHelper.getInheritedPropertiesService();
        Map inheritedPropertiesDescriptors = service.getInheritedPropertiesDescriptors();
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList properties = new ArrayList();
        for (InheritedPropertiesDescriptor descriptor : inheritedPropertiesDescriptors.values()) {
            if (descriptor.allProperties()) {
                schemas.add(descriptor.getSchema());
                continue;
            }
            properties.addAll(descriptor.getProperties());
        }
        return MetadataFile.createFromSchemasAndProperties((DocumentModel)doc, schemas, properties);
    }
}

