/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.factories;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractDocumentModelFactory
implements ImporterDocumentModelFactory {
    private static final Log log = LogFactory.getLog(AbstractDocumentModelFactory.class);
    protected final FilenameNormalizer filenameNormalizer = "true".equals(Framework.getProperty((String)"nuxeo.importer.compatFilenames")) ? new CompatFilenameNormalizer() : new DefaultFilenameNormalizer();

    @Override
    public boolean isTargetDocumentModelFolderish(SourceNode node) {
        return node.isFolderish();
    }

    protected String getValidNameFromFileName(String fileName) throws ClientException {
        return this.filenameNormalizer.normalize(fileName);
    }

    protected DocumentModel setDocumentProperties(CoreSession session, Map<String, Serializable> properties, DocumentModel doc) throws ClientException {
        if (properties != null) {
            for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
                try {
                    doc.setPropertyValue(entry.getKey(), entry.getValue());
                }
                catch (PropertyNotFoundException e) {
                    String message = String.format("Property '%s' not found on document type: %s. Skipping it.", entry.getKey(), doc.getType());
                    log.debug((Object)message);
                }
            }
            doc = session.saveDocument(doc);
        }
        return doc;
    }

    protected static class DefaultFilenameNormalizer
    implements FilenameNormalizer {
        protected DefaultFilenameNormalizer() {
        }

        @Override
        public String normalize(String name) throws ClientException {
            DocumentModelImpl fake = new DocumentModelImpl("/", name, "File");
            return ((PathSegmentService)Framework.getLocalService(PathSegmentService.class)).generatePathSegment((DocumentModel)fake);
        }
    }

    protected static class CompatFilenameNormalizer
    implements FilenameNormalizer {
        protected CompatFilenameNormalizer() {
        }

        @Override
        public String normalize(String name) {
            name = IdUtils.generateId((String)name, (String)"-", (boolean)true, (int)100);
            name = name.replace("'", "");
            name = name.replace("(", "");
            name = name.replace(")", "");
            name = name.replace("+", "");
            return name;
        }
    }

    protected static interface FilenameNormalizer {
        public String normalize(String var1) throws ClientException;
    }
}

