/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.web.actions;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.mail.utils.MailCoreHelper;
import org.nuxeo.ecm.platform.mail.web.utils.MailWebConstants;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="mailActions")
@Scope(value=ScopeType.CONVERSATION)
public class MailActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MailActionsBean.class);
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;

    public String checkCurrentInbox() throws ClientException {
        DocumentModel mailFolder = this.navigationContext.getCurrentDocument();
        try {
            MailCoreHelper.checkMail((DocumentModel)mailFolder, (CoreSession)this.documentManager);
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.check.mail.error") + e.getMessage(), new Object[0]);
            return MailWebConstants.CURRENT_PAGE;
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.check.mail.success"), new Object[0]);
        return MailWebConstants.CURRENT_PAGE;
    }

    public boolean isMailFolder() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return "MailFolder".equals(currentDocument.getType());
    }
}

