/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.ImageModelCache;
import it.tidalwave.image.op.ImplementationFactory;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageModel
implements Externalizable {
    private Serializable id = "" + System.nanoTime();

    public ImageModel() {
        ImageModelCache.getInstance().register(this);
    }

    public Serializable getId() {
        return this.id;
    }

    public void setImage(Object image) {
        ImageModelCache.getInstance().update(this);
    }

    public abstract Object getImage();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract EditableImage.DataType getDataType();

    public abstract int getBandCount();

    public abstract ImplementationFactory getFactory();

    public abstract ColorModel getColorModel();

    public abstract EditableImage createCopy(boolean var1);

    public abstract <T> T getInnerProperty(Class<T> var1);

    public abstract void dispose();

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.writeExternal(dos);
        dos.flush();
        byte[] buffer = baos.toByteArray();
        out.writeInt(buffer.length);
        out.write(buffer);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size > 0) {
            byte[] buffer = new byte[size];
            in.read(buffer);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buffer));
            this.readExternal(dis);
        }
    }

    public abstract void writeExternal(DataOutputStream var1) throws IOException;

    public abstract void readExternal(DataInputStream var1) throws IOException;
}

