/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.op;

import it.tidalwave.image.ImageModel;
import it.tidalwave.image.op.Operation;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class ImplementationFactory {
    private static final String CLASS = ImplementationFactory.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private Class modelClass;
    private Map<Class, Class> implementationMapping = new HashMap<Class, Class>();

    public ImplementationFactory(Class modelClass) {
        this.modelClass = modelClass;
    }

    public Class getModelClass() {
        return this.modelClass;
    }

    public void registerImplementation(Class operationClass, Class implementationClass) {
        this.implementationMapping.put(operationClass, implementationClass);
    }

    public void unregisterImplementation(Class operationClass) {
        this.implementationMapping.remove(operationClass);
    }

    public OperationImplementation findImplementation(Operation operation) {
        Class clazz = this.implementationMapping.get(operation.getClass());
        if (clazz != null) {
            try {
                OperationImplementation implementation = (OperationImplementation)clazz.newInstance();
                implementation.setFactory(this);
                implementation.bind(operation);
                return implementation;
            }
            catch (IllegalAccessException e) {
                logger.throwing(CLASS, "findImplementation()", e);
            }
            catch (InstantiationException e) {
                logger.throwing(CLASS, "findImplementation()", e);
            }
        }
        return null;
    }

    public ImageModel createImageModel(BufferedImage image) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean canConvertFrom(Class var1);

    public abstract ImageModel convertFrom(Object var1);

    public abstract boolean canConvertTo(Class var1);

    public abstract Object convertTo(Object var1);

    public String toString() {
        return "ImplementationFactory[" + this.modelClass + "]";
    }
}

