/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetSpec {
    public static final String DEFAULT_VIEW = "default";
    public static final Locale DEFAULT_LOCALE = new Locale("all", "ALL");
    private final Uri url;
    private final String checksum;
    private ModulePrefs modulePrefs;
    private List<UserPref> userPrefs;
    private Map<String, View> views;
    private final Map<String, Object> attributes = new MapMaker().makeMap();

    public GadgetSpec(Uri url, Element doc, String original) throws SpecParserException {
        this.url = url;
        this.checksum = HashUtil.checksum((byte[])original.getBytes());
        NodeList children = doc.getChildNodes();
        ModulePrefs modulePrefs = null;
        LinkedList userPrefs = Lists.newLinkedList();
        HashMap views = Maps.newHashMap();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String name = element.getTagName();
            if ("ModulePrefs".equals(name)) {
                if (modulePrefs == null) {
                    modulePrefs = new ModulePrefs(element, url);
                } else {
                    throw new SpecParserException("Only 1 ModulePrefs is allowed.");
                }
            }
            if ("UserPref".equals(name)) {
                UserPref pref = new UserPref(element);
                userPrefs.add(pref);
            }
            if (!"Content".equals(name)) continue;
            String viewNames = XmlUtil.getAttribute((Node)element, (String)"view", (String)DEFAULT_VIEW);
            for (String view : viewNames.split(",")) {
                List viewElements = (List)views.get(view = view.trim());
                if (viewElements == null) {
                    viewElements = Lists.newLinkedList();
                    views.put(view, viewElements);
                }
                viewElements.add(element);
            }
        }
        if (modulePrefs == null) {
            throw new SpecParserException("At least 1 ModulePrefs is required.");
        }
        this.modulePrefs = modulePrefs;
        if (views.isEmpty()) {
            throw new SpecParserException("At least 1 Content is required.");
        }
        HashMap tmpViews = Maps.newHashMap();
        for (Map.Entry view : views.entrySet()) {
            View v = new View((String)view.getKey(), (List)view.getValue(), url);
            tmpViews.put(v.getName(), v);
        }
        this.views = ImmutableMap.copyOf((Map)tmpViews);
        this.userPrefs = userPrefs.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf((Iterable)userPrefs);
    }

    public GadgetSpec(Uri url, String xml) throws SpecParserException {
        this(url, XmlUtil.parseSilent((String)xml), xml);
    }

    private GadgetSpec(GadgetSpec spec) {
        this.url = spec.url;
        this.checksum = spec.checksum;
        this.attributes.putAll(spec.attributes);
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ModulePrefs getModulePrefs() {
        return this.modulePrefs;
    }

    public List<UserPref> getUserPrefs() {
        return this.userPrefs;
    }

    public Map<String, View> getViews() {
        return this.views;
    }

    public View getView(String name) {
        return this.views.get(name);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object o) {
        this.attributes.put(key, o);
    }

    public GadgetSpec substitute(Substitutions substituter) {
        GadgetSpec spec = new GadgetSpec(this);
        spec.modulePrefs = this.modulePrefs.substitute(substituter);
        if (this.userPrefs.isEmpty()) {
            spec.userPrefs = Collections.emptyList();
        } else {
            ArrayList prefs = Lists.newArrayListWithCapacity((int)this.userPrefs.size());
            for (UserPref pref : this.userPrefs) {
                prefs.add(pref.substitute(substituter));
            }
            spec.userPrefs = ImmutableList.copyOf((Iterable)prefs);
        }
        ImmutableMap.Builder viewMap = ImmutableMap.builder();
        for (View view : this.views.values()) {
            viewMap.put((Object)view.getName(), (Object)view.substitute(substituter));
        }
        spec.views = viewMap.build();
        return spec;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Module>\n").append(this.modulePrefs).append('\n');
        for (UserPref userPref : this.userPrefs) {
            buf.append(userPref).append('\n');
        }
        for (Map.Entry entry : this.views.entrySet()) {
            buf.append(entry.getValue()).append('\n');
        }
        buf.append("</Module>");
        return buf.toString();
    }
}

