/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core;

import org.nuxeo.gwt.habyt.upload.client.FileRef;
import org.nuxeo.gwt.habyt.upload.client.FileView;
import org.nuxeo.gwt.habyt.upload.client.Uploader;
import org.nuxeo.gwt.habyt.upload.client.widgets.ProgressBar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class DefaultFileView extends FileView {

    protected Image remove;

    protected Anchor label;

    protected ProgressBar progressBar;

    protected HTML details;

    public DefaultFileView(Uploader uploader, FileRef ref) {
        super(uploader, ref);
    }

    @Override
    protected Widget createWidget() {
        FlowPanel panel = new FlowPanel();
        remove = new Image(GWT.getModuleBaseURL() + "delete.gif");
        remove.setStyleName("file-icon");
        remove.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                remove();
            }
        });
        label = new Anchor(file.getName());
        label.setHref(uploader.getViewUrl(file.getId()));
        label.setTarget("_blank");
        label.addStyleName("file-label");
        progressBar = new ProgressBar();
        details = new InlineHTML();
        details.addStyleName("file-status");
        progressBar.setVisible(false);
        details.setVisible(false);
        panel.add(remove);
        panel.add(label);
        panel.add(progressBar);
        panel.add(details);
        return panel;
    }

    protected void onUploading() {
        progressBar.setPercent(file.getProgress());
        progressBar.setVisible(true);
        if (file.getDescription().length() > 0) {
            details.setText(file.getDescription());
            details.setVisible(true);
        } else {
            details.setVisible(false);
        }
    }

    protected void onUploadDone() {
        progressBar.setVisible(false);
        details.setHTML(file.getDescription());
        details.getElement().getStyle().setColor("green");
        details.addStyleName("file-upload-done");
        details.setVisible(true);
    }

    protected void onUploadError() {
        progressBar.setVisible(false);
        details.setHTML("Error");
        details.addStyleName("file-upload-error");
        details.setVisible(true);
    }

    protected void onQueued() {
        details.setVisible(false);
        progressBar.setPercent(file.getProgress());
        progressBar.setVisible(true);
    }

    protected void onStored() {
        progressBar.setVisible(false);
        details.setHTML(file.getDescription());
        details.getElement().getStyle().setColor("gray");
        details.addStyleName("file-upload-stored");
        details.setVisible(true);
    }

}
