/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client;

import com.google.gwt.dom.client.BaseElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.nuxeo.ecm.platform.annotations.gwt.client.AnnotationConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.AnnotationManagerPanel;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.HideManagerButton;

public class AnnotationApplication {
    private static WebConfiguration WEB_CONFIGURATION;
    private static DockPanel applicationPanel;
    private static Frame PREVIEW_FRAME;

    public static void build(WebConfiguration webConfiguration) {
        WEB_CONFIGURATION = webConfiguration;
        AnnotationApplication.buildApplication();
    }

    private static void buildApplication() {
        AnnotationConfiguration annotationConfiguration = AnnotationConfiguration.getInstance();
        Document document = Document.get();
        BaseElement baseElement = (BaseElement)((Element)document.getElementsByTagName("base").getItem(0)).cast();
        AnnotationApplication.registerBaseHref(baseElement.getHref());
        AnnotationApplication.registerAnnoteaServerUrl(annotationConfiguration.getAnnoteaServerUrl());
        AnnotationApplication.registerDocUrl(annotationConfiguration.getDocumentUrl());
        AnnotationApplication.notifyAnnoteaServerUrlRegistered();
        applicationPanel.setStyleName("annotationApplicationPanel");
        applicationPanel.setWidth("100%");
        RootPanel display = RootPanel.get((String)"display");
        String height = Integer.toString(display.getOffsetHeight()) + "px";
        applicationPanel.setHeight(height);
        applicationPanel.setHorizontalAlignment(DockPanel.ALIGN_LEFT);
        PREVIEW_FRAME = new Frame(annotationConfiguration.getPreviewUrl());
        PREVIEW_FRAME.setStyleName("previewFrame");
        PREVIEW_FRAME.setWidth("100%");
        PREVIEW_FRAME.setHeight(height);
        applicationPanel.add((Widget)PREVIEW_FRAME, DockPanel.CENTER);
        applicationPanel.setCellWidth((Widget)PREVIEW_FRAME, "100%");
        AnnotationController controller = new AnnotationController(WEB_CONFIGURATION, false);
        AnnotationManagerPanel annotationManagerPanel = new AnnotationManagerPanel(controller, WEB_CONFIGURATION);
        controller.addModelChangeListener(annotationManagerPanel);
        HideManagerButton hideManagerButton = new HideManagerButton(controller, annotationManagerPanel, PREVIEW_FRAME);
        annotationManagerPanel.setWidth("250px");
        applicationPanel.add((Widget)annotationManagerPanel, DockPanel.WEST);
        hideManagerButton.setHeight(height);
        applicationPanel.add((Widget)hideManagerButton, DockPanel.WEST);
        display.add((Widget)applicationPanel);
        controller.loadAnnotations();
    }

    private static native void registerBaseHref(String var0);

    private static native void registerAnnoteaServerUrl(String var0);

    private static native void notifyAnnoteaServerUrlRegistered();

    private static native void registerDocUrl(String var0);

    static {
        applicationPanel = new DockPanel();
    }
}

