/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.jsf;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.faceted.search.jsf.FacetedSearchActions;
import org.nuxeo.ecm.platform.suggestbox.jsf.Cached;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionHandlingException;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;
import org.nuxeo.ecm.virtualnavigation.action.MultiNavTreeManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="suggestboxActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class SuggestboxActions
extends DocumentContextBoundActionBean
implements Serializable {
    private static final Log log = LogFactory.getLog(SuggestboxActions.class);
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true)
    protected Locale locale;
    @In(create=true)
    protected MultiNavTreeManager multiNavTreeManager;
    @In(create=true)
    protected FacetedSearchActions facetedSearchActions;
    @In(create=true)
    protected ContentViewActions contentViewActions;
    protected Cached<List<Suggestion>> cachedSuggestions = new Cached(10000L);
    protected String searchKeywords = "";
    protected String suggesterGroup;

    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    public String getSuggesterGroup() {
        return this.suggesterGroup;
    }

    @RequestParameter
    public void setSuggesterGroup(String suggesterGroup) {
        this.suggesterGroup = suggesterGroup;
    }

    protected SuggestionContext getSuggestionContext() {
        SuggestionContext ctx = new SuggestionContext(this.suggesterGroup, this.documentManager.getPrincipal()).withSession(this.documentManager).withCurrentDocument(this.navigationContext.getCurrentDocument()).withLocale(this.locale).withMessages(this.messages);
        return ctx;
    }

    public List<Suggestion> getSuggestions(Object input) {
        if (this.cachedSuggestions.hasExpired(input, this.locale)) {
            SuggestionService service = (SuggestionService)Framework.getLocalService(SuggestionService.class);
            SuggestionContext ctx = this.getSuggestionContext();
            try {
                List suggestions = service.suggest(input.toString(), ctx);
                this.cachedSuggestions.cache(suggestions, input, this.locale);
            }
            catch (SuggestionException e) {
                log.error((Object)e, (Throwable)e);
                return Collections.emptyList();
            }
        }
        return (List)this.cachedSuggestions.value;
    }

    public Object handleSelection(Suggestion selectedSuggestion) throws SuggestionHandlingException {
        SuggestionService service = (SuggestionService)Framework.getLocalService(SuggestionService.class);
        SuggestionContext ctx = this.getSuggestionContext();
        this.searchKeywords = "";
        return service.handleSelection(selectedSuggestion, ctx);
    }

    public Object performKeywordsSearch(String suggesterName, String suggesterGroup) throws SuggestionException, SuggestionHandlingException {
        SuggestionContext context;
        this.suggesterGroup = suggesterGroup;
        SuggestionService service = (SuggestionService)Framework.getLocalService(SuggestionService.class);
        List suggestions = service.suggest(this.searchKeywords, context = this.getSuggestionContext(), suggesterName);
        if (suggestions.size() != 1) {
            throw new SuggestionException(String.format("Expected 1 keyword search suggestion, got %d", suggestions.size()));
        }
        return service.handleSelection((Suggestion)suggestions.get(0), context);
    }

    protected void resetBeanCache(DocumentModel newCurrentDocumentModel) {
        this.cachedSuggestions.expire();
    }
}

