/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image;

public class Rational
extends Number {
    private final int numerator;
    private final int denominator;

    public Rational(com.drew.lang.Rational r) {
        this(r.getNumerator(), r.getDenominator());
    }

    public Rational(int i, int j) {
        this.numerator = i;
        this.denominator = j;
    }

    public Rational(double d) {
        this.denominator = 100000;
        this.numerator = (int)Math.round(d * (double)this.denominator);
    }

    public final double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public final float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    public final int intValue() {
        return (int)this.doubleValue();
    }

    public final long longValue() {
        return (long)this.doubleValue();
    }

    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final int getDenominator() {
        return this.denominator;
    }

    public final int getNumerator() {
        return this.numerator;
    }

    public final Rational divide(double det) {
        return new Rational(this.numerator, (int)Math.round((double)this.denominator * det));
    }

    public final Rational getReciprocal() {
        return new Rational(this.denominator, this.numerator);
    }

    public final boolean isInteger() {
        return this.denominator == 1 || this.denominator != 0 && this.numerator % this.denominator == 0 || this.denominator == 0 && this.numerator == 0;
    }

    public final String toString() {
        return this.numerator + "/" + this.denominator;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Rational)) {
            return false;
        }
        Rational rational = (Rational)object;
        return this.denominator == rational.denominator && this.numerator == rational.numerator;
    }

    public final int hashCode() {
        return this.numerator ^ this.denominator;
    }
}

