/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.metadata;

import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import it.tidalwave.image.Rational;
import it.tidalwave.image.metadata.DirectoryAdapter;
import java.util.Date;

public class DirectoryTIFFAdapter
implements DirectoryAdapter {
    private TIFFIFD ifd;

    public DirectoryTIFFAdapter(Object ifd) {
        this.ifd = (TIFFIFD)ifd;
    }

    public int[] getTags() {
        TIFFField[] fields = this.ifd.getTIFFFields();
        int[] result = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].getTagNumber();
        }
        return result;
    }

    public String[] getSubDirectoryNames() {
        return new String[0];
    }

    public DirectoryAdapter getSubDirectory(String name) {
        return null;
    }

    public String getTagName(int tag) {
        return "TIFF#" + tag;
    }

    public boolean containsTag(int tag) {
        return this.ifd.getTIFFField(tag) != null;
    }

    public Object getObject(int tag) {
        return this.ifd.getTIFFField(tag).getData();
    }

    public int getInteger(int tag) {
        return this.ifd.getTIFFField(tag).getAsInt(0);
    }

    public int getShort(int tag) {
        return this.ifd.getTIFFField(tag).getAsInt(0);
    }

    public short[] getShortArray(int tag) {
        return this.ifd.getTIFFField(tag).getAsShorts();
    }

    public String[] getStringArray(int tag) {
        return new String[]{this.ifd.getTIFFField(tag).getAsString(0)};
    }

    public int[] getIntegerArray(int tag) {
        return this.ifd.getTIFFField(tag).getAsInts();
    }

    public int getByte(int tag) {
        return this.ifd.getTIFFField(tag).getAsInt(0);
    }

    public byte[] getByteArray(int tag) {
        return this.ifd.getTIFFField(tag).getAsBytes();
    }

    public double getDouble(int tag) {
        return this.ifd.getTIFFField(tag).getAsDouble(0);
    }

    public double[] getDoubleArray(int tag) {
        return this.ifd.getTIFFField(tag).getAsDoubles();
    }

    public float getFloat(int tag) {
        return this.ifd.getTIFFField(tag).getAsFloat(0);
    }

    public long getLong(int tag) {
        return this.ifd.getTIFFField(tag).getAsLong(0);
    }

    public boolean getBoolean(int tag) {
        return this.getInteger(tag) != 0;
    }

    public Date getDate(int tag) {
        return null;
    }

    public Rational getRational(int tag) {
        long[] l = this.ifd.getTIFFField(tag).getAsRational(0);
        return new Rational((int)l[0], (int)l[1]);
    }

    public Rational[] getRationalArray(int tag) {
        long[][] l = this.ifd.getTIFFField(tag).getAsRationals();
        Rational[] r = new Rational[l.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new Rational((int)l[i][0], (int)l[i][1]);
        }
        return r;
    }

    public String getString(int tag) {
        return this.ifd.getTIFFField(tag).getAsString(0);
    }
}

