/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Join {
    public static String join(CharSequence sep, CharSequence ... items) {
        int n = items.length;
        int sumOfLengths = sep.length() * n;
        int i = n;
        while (--i >= 0) {
            sumOfLengths += items[i].length();
        }
        StringBuilder sb = new StringBuilder(sumOfLengths);
        Join.join(sb, sep, items);
        return sb.toString();
    }

    public static String join(CharSequence sep, Iterable<? extends CharSequence> items) {
        StringBuilder sb = new StringBuilder();
        Join.join(sb, sep, items);
        return sb.toString();
    }

    public static void join(Appendable out, CharSequence sep, Iterable<? extends CharSequence> items) throws IOException {
        Iterator<? extends CharSequence> it = items.iterator();
        if (!it.hasNext()) {
            return;
        }
        out.append(it.next());
        while (it.hasNext()) {
            out.append(sep).append(it.next());
        }
    }

    public static void join(StringBuilder out, CharSequence sep, Iterable<? extends CharSequence> items) {
        try {
            Join.join((Appendable)out, sep, items);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void join(Appendable out, CharSequence sep, CharSequence ... items) throws IOException {
        Join.join(out, sep, Arrays.asList(items));
    }

    public static void join(StringBuilder out, CharSequence sep, CharSequence ... items) {
        try {
            Join.join((Appendable)out, sep, Arrays.asList(items));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

