/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.json;

import java.util.Collection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.common.utils.StringUtils;

public abstract class JQueryTreeBuilder<T> {
    public static final String CHILDREN = "children";

    public JSONArray buildTree(String rootName, String path) {
        return this.buildTree(rootName, path);
    }

    public JSONArray buildTree(T root, String path) {
        String name;
        if (path == null || path.length() == 0 || "/".equals(path)) {
            return this.buildChildren(root);
        }
        String[] ar = StringUtils.split((String)path, (char)'/', (boolean)false);
        if (ar.length > 1 && (name = this.getName(root)).equals(ar[0])) {
            return this.buildChildren(root, ar, 1);
        }
        return this.buildChildren(root);
    }

    public JSONArray buildChildren(T parent) {
        JSONArray json = new JSONArray();
        Collection<T> children = this.getChildren(parent);
        if (children != null) {
            for (T obj : children) {
                JSONObject map = this.toJson(obj);
                json.add((Object)map);
            }
        }
        return json;
    }

    public JSONArray buildChildren(T parent, String[] path, int off) {
        JSONArray json = new JSONArray();
        String expandName = path[off];
        Collection<T> children = this.getChildren(parent);
        if (children != null) {
            for (T obj : children) {
                JSONObject map = this.toJson(obj);
                String childName = this.getName(obj);
                if (expandName.equals(childName)) {
                    JSONArray jsonChildren = null;
                    jsonChildren = off < path.length - 1 ? this.buildChildren(obj, path, off + 1) : this.buildChildren(obj);
                    map.element(CHILDREN, (Collection)jsonChildren);
                }
                json.add((Object)map);
            }
        }
        return json;
    }

    protected abstract T getObject(String var1);

    protected abstract String getName(T var1);

    protected abstract Collection<T> getChildren(T var1);

    protected abstract JSONObject toJson(T var1);
}

