/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.Quality;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.OptimizeOp;
import java.awt.image.BufferedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeJ2DOp
extends OperationImplementation<OptimizeOp, BufferedImage> {
    private static final String CLASS = OptimizeJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Override
    protected BufferedImage execute(OptimizeOp operation, BufferedImage bufferedImage) {
        Java2DUtils.logImage(logger, ">>>> source bufferedImage", bufferedImage);
        double scale = operation.getScale();
        Quality quality = operation.getQuality();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            logger.finer(">>>> calling convertToSinglePixelPackedSampleModel()");
            bufferedImage = Java2DUtils.convertToSinglePixelPackedSampleModel(bufferedImage);
            logger.finer(">>>>>>>> iccProfile is now: " + Java2DUtils.getICCProfileName(bufferedImage));
        }
        BufferedImage result = Java2DUtils.createOptimizedImage(bufferedImage, scale, scale, quality);
        Java2DUtils.logImage(logger, ">>>> createOptimizedScaledImage() returning ", result);
        return result;
    }
}

