/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.RotateQuadrantOp;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateQuadrantJ2DOp
extends OperationImplementation<RotateQuadrantOp, BufferedImage> {
    private static final String CLASS = RotateQuadrantJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferedImage execute(RotateQuadrantOp operation, BufferedImage bufferedImage) {
        int degrees = operation.getDegrees();
        logger.fine("rotateQuadrant(" + degrees + ")");
        Java2DUtils.logImage(logger, ">>>> source bufferedImage", bufferedImage);
        if (degrees == 0) {
            return bufferedImage;
        }
        int newWidth = bufferedImage.getWidth();
        int newHeight = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        if (degrees == 90 || degrees == 270) {
            sampleModel = sampleModel.createCompatibleSampleModel(bufferedImage.getHeight(), bufferedImage.getWidth());
        }
        WritableRaster newRaster = Raster.createWritableRaster(sampleModel, null);
        ColorModel colorModel = bufferedImage.getColorModel();
        BufferedImage result = new BufferedImage(colorModel, newRaster, false, Java2DUtils.getProperties(bufferedImage));
        Graphics2D g2d = (Graphics2D)result.getGraphics();
        try {
            double radians = Math.toRadians(degrees);
            g2d.transform(AffineTransform.getRotateInstance(radians));
            int x = 0;
            int y = 0;
            switch (degrees) {
                case 90: {
                    y = -bufferedImage.getHeight();
                    break;
                }
                case 180: {
                    x = -bufferedImage.getWidth();
                    y = -bufferedImage.getHeight();
                    break;
                }
                case 270: {
                    x = -bufferedImage.getWidth();
                }
            }
            g2d.drawImage((Image)bufferedImage, x, y, null);
        }
        finally {
            g2d.dispose();
        }
        Java2DUtils.logImage(logger, ">>>> rotateQuadrant() returning ", result);
        return result;
    }
}

