/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.Quality;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.ScaleOp;
import it.tidalwave.image.util.Platform;
import java.awt.image.BufferedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleJ2DOp
extends OperationImplementation<ScaleOp, BufferedImage> {
    private static final String CLASS = ScaleJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Override
    protected BufferedImage execute(ScaleOp operation, BufferedImage bufferedImage) {
        double xScale = operation.getXScale();
        double yScale = operation.getYScale();
        Quality quality = operation.getQuality();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        logger.fine("execute(" + xScale + ", " + yScale + ", " + (Object)((Object)quality));
        Java2DUtils.logImage(logger, ">>>> ", bufferedImage);
        boolean optimizedImage = sampleModel.getClass().equals(SinglePixelPackedSampleModel.class);
        BufferedImage result = Platform.isMacOSX() && quality == Quality.INTERMEDIATE && !optimizedImage ? Java2DUtils.scaleWithDrawImage(bufferedImage, xScale, yScale, quality) : (Platform.isLinux() && bufferedImage.getClass().getName().equals("sun.awt.motif.X11RemoteOffScreenImage") ? Java2DUtils.scaleWithDrawImage(bufferedImage, xScale, yScale, quality) : Java2DUtils.scaleWithAffineTransform(bufferedImage, xScale, yScale, quality));
        logger.fine(">>>> Scaled image size is: w=" + result.getWidth() + " h=" + result.getHeight());
        return result;
    }
}

