/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotatedDocumentEventListener;
import org.nuxeo.runtime.api.Framework;

public class AnnotatedDocumentEventListenerImpl
implements AnnotatedDocumentEventListener {
    private static final Log log = LogFactory.getLog(AnnotatedDocumentEventListenerImpl.class);

    @Override
    public void beforeAnnotationCreated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void beforeAnnotationDeleted(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void beforeAnnotationRead(NuxeoPrincipal principal, String annotationId) {
    }

    @Override
    public void beforeAnnotationUpdated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void afterAnnotationCreated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent("annotationCreated", annotation, documentLoc, principal);
    }

    @Override
    public void afterAnnotationDeleted(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent("annotationDeleted", annotation, documentLoc, principal);
    }

    @Override
    public void afterAnnotationRead(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void afterAnnotationUpdated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent("annotationUpdated", annotation, documentLoc, principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void notifyEvent(String eventId, Annotation annotation, DocumentLocation documentLocation, NuxeoPrincipal principal) {
        block25: {
            String title;
            CoreSession session;
            LoginContext loginContext;
            block23: {
                loginContext = null;
                session = null;
                title = null;
                DocumentModel doc = null;
                loginContext = Framework.login();
                session = this.getSession(documentLocation.getServerName());
                if (session.exists(documentLocation.getDocRef())) {
                    doc = session.getDocument(documentLocation.getDocRef());
                    title = doc.getTitle();
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("annotationId", annotation.getId());
                properties.put("annotationSubject", (String)annotation.getSubject());
                properties.put("annotationBody", annotation.getBodyAsText());
                EventContextImpl ctx = null;
                if (doc != null) {
                    DocumentEventContext docCtx = new DocumentEventContext(session, (Principal)principal, doc);
                    docCtx.setCategory("eventDocumentCategory");
                    ctx = docCtx;
                } else {
                    ctx = new EventContextImpl(session, (Principal)principal);
                }
                ctx.setRepositoryName(documentLocation.getServerName());
                ctx.setProperties(properties);
                Event event = ctx.newEvent(eventId);
                ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
                if (session == null) break block23;
                try {
                    session.save();
                }
                catch (ClientException e) {
                    log.error((Object)String.format("error saving core session for annotation event %d on document '%s'", eventId, title), (Throwable)e);
                }
                CoreInstance.getInstance().close(session);
            }
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {
                    log.error((Object)("Unable to logout: " + e.getMessage()));
                }
            }
            break block25;
            catch (Exception e) {
                block24: {
                    try {
                        log.error((Object)("Unable to send the " + eventId + " event"), (Throwable)e);
                        if (session == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            try {
                                session.save();
                            }
                            catch (ClientException e2) {
                                log.error((Object)String.format("error saving core session for annotation event %d on document '%s'", eventId, title), (Throwable)e2);
                            }
                            CoreInstance.getInstance().close(session);
                        }
                        if (loginContext != null) {
                            try {
                                loginContext.logout();
                            }
                            catch (LoginException e3) {
                                log.error((Object)("Unable to logout: " + e3.getMessage()));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        session.save();
                    }
                    catch (ClientException e4) {
                        log.error((Object)String.format("error saving core session for annotation event %d on document '%s'", eventId, title), (Throwable)e4);
                    }
                    CoreInstance.getInstance().close(session);
                }
                if (loginContext != null) {
                    try {
                        loginContext.logout();
                    }
                    catch (LoginException e5) {
                        log.error((Object)("Unable to logout: " + e5.getMessage()));
                    }
                }
            }
        }
    }

    protected CoreSession getSession(String repoName) throws Exception {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repository = repositoryManager.getRepository(repoName);
        return repository.open();
    }
}

