/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.model;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationFilter;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationChangeListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationChangeNotifier;

public class AnnotationModel
implements AnnotationChangeNotifier {
    private static final Comparator<Annotation> ANNOTATION_DATE_COMPARATOR = new Comparator<Annotation>(){

        @Override
        public int compare(Annotation o1, Annotation o2) {
            return o1.getDate().compareTo(o2.getDate());
        }
    };
    private Annotation newAnnotation;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private List<Annotation> filteredAnnotations;
    private AnnotationFilter filter;
    private List<AnnotationChangeListener> listeners = new ArrayList<AnnotationChangeListener>();

    @Override
    public void addChangeListener(AnnotationChangeListener listener) {
        this.listeners.add(listener);
    }

    public Annotation getNewAnnotation() {
        return this.newAnnotation;
    }

    public void setNewAnnotation(Annotation newAnnotation) {
        this.newAnnotation = newAnnotation;
        this.notifyListener(AnnotationChangeListener.ChangeEvent.annotation);
    }

    private void notifyListener(AnnotationChangeListener.ChangeEvent ce) {
        GWT.log((String)"Notifying listener.", null);
        for (AnnotationChangeListener listener : this.listeners) {
            listener.onChange(this, ce);
        }
    }

    public List<Annotation> getAnnotations() {
        if (this.filteredAnnotations != null) {
            return this.filteredAnnotations;
        }
        return this.annotations;
    }

    public List<Annotation> getUnfilteredAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        Collections.sort(annotations, ANNOTATION_DATE_COMPARATOR);
        this.annotations = annotations;
        int id = 0;
        for (Annotation annotation : annotations) {
            annotation.setId(id++);
        }
        if (this.filter != null) {
            this.filteredAnnotations = this.filterAnnotations(this.filter);
        }
        this.notifyListener(AnnotationChangeListener.ChangeEvent.annotationList);
    }

    public List<Annotation> filterAnnotations(AnnotationFilter filter) {
        ArrayList<Annotation> filteredAnnotations = new ArrayList<Annotation>();
        for (Annotation annotation : this.annotations) {
            if (!filter.accept(annotation)) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    public void setFilter(AnnotationFilter filter) {
        this.filter = filter;
        this.filteredAnnotations = this.filterAnnotations(filter);
        this.notifyListener(AnnotationChangeListener.ChangeEvent.annotationList);
    }

    public AnnotationFilter getFilter() {
        return this.filter;
    }
}

