/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.handlers;

import org.jboss.seam.Component;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.platform.faceted.search.jsf.FacetedSearchActions;
import org.nuxeo.ecm.platform.suggestbox.service.DocumentSuggestion;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.virtualnavigation.action.MultiNavTreeManager;
import org.nuxeo.ecm.webapp.context.NavigationContextBean;

@Operation(id="Suggestion.JSF.NavigateToDocument", category="User Interface", label="Suggestion handler for navigation to document view", description="Handles JSF navigation given a DocumentSuggestion as input.")
public class NavigateToDocumentSuggestionHandler {
    public static final String ID = "Suggestion.JSF.NavigateToDocument";
    @Param(name="navigationTree", required=false)
    public String navigationTree = "CONTENT_TREE";
    @Param(name="updateNavigationTree", required=false)
    public boolean updateNavigationTree = true;
    @Param(name="clearFacetedSearch", required=false)
    public boolean clearFacetedSearch = false;

    @OperationMethod
    public Object run(Object input) throws OperationException, ClientException {
        if (!(input instanceof DocumentSuggestion)) {
            throw new OperationException(String.format("Expected an instance of DocumentSuggestion, got '%s'", input));
        }
        if (this.updateNavigationTree) {
            MultiNavTreeManager multiNavTreeManager = (MultiNavTreeManager)Component.getInstance(MultiNavTreeManager.class);
            multiNavTreeManager.setSelectedNavigationTree(this.navigationTree);
        }
        if (this.clearFacetedSearch) {
            FacetedSearchActions facetedSearchActions = (FacetedSearchActions)Component.getInstance(FacetedSearchActions.class);
            facetedSearchActions.clearSearch();
        }
        DocumentSuggestion suggestion = (DocumentSuggestion)input;
        NavigationContext navigationContext = (NavigationContext)Component.getInstance(NavigationContextBean.class);
        DocumentLocation docLoc = suggestion.getDocumentLocation();
        return navigationContext.navigateTo(new RepositoryLocation(docLoc.getServerName()), docLoc.getDocRef());
    }
}

