/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ContentType {
    CSS("text/css", "css", true),
    JS("text/javascript", "js", true),
    JSON("application/json", "json", true),
    HTML("text/html", "html", true),
    XML("application/xhtml+xml", "xhtml", true),
    ZIP("application/zip", "zip", false);

    final String mimeType;
    final String ext;
    final boolean isText;
    private static final Map<String, ContentType> MIME_TYPES;

    private ContentType(String contentType, String ext, boolean isText) {
        this.mimeType = contentType;
        this.ext = ext;
        this.isText = isText;
    }

    static ContentType guess(String mimeType, String path, CharSequence code) {
        int dot;
        ContentType contentType = null;
        if (mimeType != null) {
            int semi = mimeType.indexOf(59);
            String baseType = semi < 0 ? mimeType : mimeType.substring(0, semi);
            contentType = MIME_TYPES.get(Strings.toLowerCase(baseType).trim());
        }
        if (contentType == null && path != null && (dot = path.lastIndexOf(46)) >= 0) {
            String ext = path.substring(dot + 1);
            for (ContentType candidate : ContentType.values()) {
                if (!ext.equals(candidate.ext)) continue;
                contentType = candidate;
                break;
            }
        }
        if (contentType == null && code != null) {
            char ch = '\u0000';
            int n = code.length();
            for (int i = 0; i < n && Character.isWhitespace(ch = (char)code.charAt(i)); ++i) {
            }
            switch (ch) {
                case '<': {
                    contentType = HTML;
                    break;
                }
                case '#': 
                case '.': 
                case '@': {
                    contentType = CSS;
                }
            }
        }
        if (contentType == null && code != null) {
            CharProducer cp = CharProducer.Factory.fromString(code, FilePosition.UNKNOWN);
            try {
                CssLexer cssLexer = new CssLexer(cp, DevNullMessageQueue.singleton(), false);
                contentType = CSS;
                while (cssLexer.hasNext()) {
                    Token<CssTokenType> t = cssLexer.next();
                    if (!"if".equals(t.text) && !"while".equals(t.text) && !"for".equals(t.text) && !"return".equals(t.text)) continue;
                    contentType = JS;
                    break;
                }
            }
            catch (ParseException ex) {
                contentType = JS;
            }
        }
        return contentType;
    }

    static {
        MIME_TYPES = Maps.immutableMap().put("text/javascript", JS).put("application/x-javascript", JS).put("application/javascript", JS).put("text/ecmascript", JS).put("application/ecmascript", JS).put("text/jscript", JS).put("text/css", CSS).put("text/html", HTML).put("application/xml", XML).put("application/xhtml+xml", XML).put("application/x-winzip", ZIP).put("application/zip", ZIP).put("application/x-java-archive", ZIP).create();
    }
}

