/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.html;

import com.google.caja.config.ConfigUtil;
import com.google.caja.config.WhiteList;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.RegularCriterion;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Multimap;
import com.google.caja.util.Multimaps;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlSchema {
    private final Set<ElKey> allowedElements;
    private final Map<ElKey, HTML.Element> elementDetails;
    private final Set<AttribKey> allowedAttributes = Sets.newHashSet();
    private final Map<AttribKey, HTML.Attribute> attributeDetails;
    private static Pair<HtmlSchema, List<Message>> defaultSchema;

    public static HtmlSchema getDefault(MessageQueue mq) {
        if (defaultSchema == null) {
            SimpleMessageQueue cacheMq = new SimpleMessageQueue();
            URI elSrc = URI.create("resource:///com/google/caja/lang/html/html4-elements-extensions.json");
            URI attrSrc = URI.create("resource:///com/google/caja/lang/html/html4-attributes-extensions.json");
            try {
                defaultSchema = Pair.pair(new HtmlSchema(ConfigUtil.loadWhiteListFromJson(elSrc, ConfigUtil.RESOURCE_RESOLVER, cacheMq), ConfigUtil.loadWhiteListFromJson(attrSrc, ConfigUtil.RESOURCE_RESOLVER, cacheMq)), cacheMq.getMessages());
            }
            catch (IOException ex) {
                mq.getMessages().addAll(cacheMq.getMessages());
                throw new RuntimeException(ex);
            }
            catch (ParseException ex) {
                cacheMq.getMessages().add(ex.getCajaMessage());
                mq.getMessages().addAll(cacheMq.getMessages());
                throw new RuntimeException(ex);
            }
        }
        mq.getMessages().addAll((Collection)HtmlSchema.defaultSchema.b);
        return (HtmlSchema)HtmlSchema.defaultSchema.a;
    }

    public static boolean isElementFoldable(ElKey el) {
        if (!el.isHtml()) {
            return false;
        }
        String cname = el.localName;
        return "head".equals(cname) || "body".equals(cname) || "html".equals(cname);
    }

    public HtmlSchema(WhiteList tagList, WhiteList attribList) {
        Object key;
        for (String key2 : attribList.allowedItems()) {
            this.allowedAttributes.add(HtmlSchema.attribKey(key2));
        }
        Map<AttribKey, RegularCriterion> criteria = Maps.newHashMap();
        for (WhiteList.TypeDefinition def : attribList.typeDefinitions().values()) {
            String values = (String)def.get("values", null);
            RegularCriterion criterion = null;
            if (values != null) {
                criterion = RegularCriterion.Factory.fromValueSet(Arrays.asList(values.split(",")));
            } else {
                String pattern = (String)def.get("pattern", null);
                if (pattern != null) {
                    criterion = RegularCriterion.Factory.fromPattern("(?i:" + pattern + ")");
                }
            }
            if (criterion == null) continue;
            key = Strings.toLowerCase((String)def.get("key", null));
            criteria.put(HtmlSchema.attribKey((String)key), criterion);
        }
        this.attributeDetails = Maps.newHashMap();
        Multimap<Object, HTML.Attribute> attributeDetailsByElement = Multimaps.newListHashMultimap();
        for (WhiteList.TypeDefinition def : attribList.typeDefinitions().values()) {
            String key3 = Strings.toLowerCase((String)def.get("key", null));
            AttribKey elAndAttrib = HtmlSchema.attribKey(key3);
            if (elAndAttrib == null) {
                throw new NullPointerException(key3);
            }
            ElKey element = elAndAttrib.el;
            HTML.Attribute.Type type = HTML.Attribute.Type.NONE;
            String typeName = (String)def.get("type", null);
            if (typeName != null) {
                type = HTML.Attribute.Type.valueOf(typeName);
            }
            String mimeTypes = (String)def.get("mimeTypes", null);
            RegularCriterion elCriterion = (RegularCriterion)criteria.get(elAndAttrib);
            RegularCriterion wcCriterion = (RegularCriterion)criteria.get(elAndAttrib.onAnyElement());
            RegularCriterion criterion = HtmlSchema.conjunction(elCriterion, wcCriterion);
            String defaultValue = (String)def.get("default", null);
            boolean optional = Boolean.TRUE.equals(def.get("optional", true));
            String safeValue = (String)def.get("safeValue", null);
            if (safeValue == null) {
                String candidate;
                String string = candidate = defaultValue != null ? defaultValue : "";
                if (criterion.accept(candidate)) {
                    safeValue = candidate;
                } else {
                    String values = (String)def.get("values", null);
                    if (values != null) {
                        safeValue = values.split(",")[0];
                    }
                }
            }
            boolean valueless = Boolean.TRUE.equals(def.get("valueless", false));
            HTML.Attribute a = new HTML.Attribute(elAndAttrib, type, defaultValue, safeValue, valueless, optional, mimeTypes, criterion);
            this.attributeDetails.put(elAndAttrib, a);
            attributeDetailsByElement.put(element, a);
        }
        this.allowedElements = Sets.newHashSet();
        for (String qualifiedName : tagList.allowedItems()) {
            this.allowedElements.add(ElKey.forElement(Namespaces.HTML_DEFAULT, qualifiedName));
        }
        this.elementDetails = Maps.newHashMap();
        for (WhiteList.TypeDefinition def : tagList.typeDefinitions().values()) {
            String qualifiedTagName = (String)def.get("key", null);
            key = ElKey.forElement(Namespaces.HTML_DEFAULT, qualifiedTagName);
            Collection specific = attributeDetailsByElement.get(key);
            ElKey wc = ElKey.wildcard(((ElKey)key).ns);
            Collection general = attributeDetailsByElement.get(wc);
            List<HTML.Attribute> attrs = Lists.newArrayList(specific);
            if (!general.isEmpty()) {
                Set<AttribKey> present = Sets.newHashSet();
                for (HTML.Attribute a : attrs) {
                    present.add(a.getKey().onElement(wc));
                }
                for (HTML.Attribute a : general) {
                    if (present.contains(a.getKey())) continue;
                    attrs.add(a);
                }
            }
            boolean empty = (Boolean)def.get("empty", Boolean.FALSE);
            boolean optionalEnd = (Boolean)def.get("optionalEnd", Boolean.FALSE);
            this.elementDetails.put((ElKey)key, new HTML.Element((ElKey)key, attrs, empty, optionalEnd));
        }
    }

    public Set<AttribKey> getAttributeNames() {
        return this.attributeDetails.keySet();
    }

    public Set<ElKey> getElementNames() {
        return this.elementDetails.keySet();
    }

    public boolean isElementAllowed(ElKey elementName) {
        return this.allowedElements.contains(elementName);
    }

    public HTML.Element lookupElement(ElKey elementName) {
        return this.elementDetails.get(elementName);
    }

    public boolean isAttributeAllowed(AttribKey k) {
        HTML.Attribute a = this.lookupAttribute(k);
        return a != null && this.allowedAttributes.contains(a.getKey());
    }

    public HTML.Attribute lookupAttribute(AttribKey k) {
        HTML.Attribute attr = this.attributeDetails.get(k);
        if (attr == null) {
            attr = this.attributeDetails.get(k.onAnyElement());
        }
        return attr;
    }

    private static AttribKey attribKey(String key) {
        int separator = key.indexOf("::");
        String elQName = key.substring(0, separator);
        String attrQName = key.substring(separator + 2);
        ElKey el = ElKey.forElement(Namespaces.HTML_DEFAULT, elQName);
        if (el == null) {
            throw new NullPointerException(elQName);
        }
        AttribKey a = AttribKey.forAttribute(Namespaces.HTML_DEFAULT, el, attrQName);
        if (a == null) {
            throw new NullPointerException(attrQName);
        }
        return a;
    }

    private static RegularCriterion conjunction(RegularCriterion a, RegularCriterion b) {
        RegularCriterion c = a;
        if (b != null) {
            c = c == null ? b : RegularCriterion.Factory.and(c, b);
        }
        return c != null ? c : RegularCriterion.Factory.optimist();
    }
}

