/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.AbstractTokenStream;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.DecodingCharProducer;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.NumberRecognizer;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.PunctuationTrie;
import com.google.caja.lexer.Token;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InputElementSplitter
extends AbstractTokenStream<JsTokenType> {
    private final DecodingCharProducer p;
    private final PunctuationTrie<?> punctuation;
    private Token<JsTokenType> lastNonCommentToken;
    private final boolean isQuasiliteral;

    public InputElementSplitter(CharProducer p, PunctuationTrie<?> punctuation) {
        this(p, punctuation, false);
    }

    public InputElementSplitter(CharProducer p, PunctuationTrie<?> punctuation, boolean isQuasiliteral) {
        this.p = this.lineContinuingCharProducer(p);
        this.punctuation = punctuation;
        this.isQuasiliteral = isQuasiliteral;
    }

    @Override
    public Token<JsTokenType> next() throws ParseException {
        Token<JsTokenType> t = super.next();
        if (t.type != JsTokenType.COMMENT) {
            this.lastNonCommentToken = t;
        }
        return t;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Token<JsTokenType> produce() throws ParseException {
        buf = this.p.getBuffer();
        start = this.p.getOffset();
        if (start < (limit = this.p.getLimit()) && JsLexer.isJsSpace(buf[start])) {
            ++start;
            while (start < limit && JsLexer.isJsSpace(buf[start])) {
                if (this.tokenBreak(start)) {
                    this.p.consumeTo(start);
                    return Token.instance("\\", JsTokenType.LINE_CONTINUATION, this.p.getCurrentPosition());
                }
                ++start;
            }
            this.p.consumeTo(start);
        }
        if (this.p.isEmpty()) {
            return null;
        }
        ch = buf[start];
        block0 : switch (ch) {
            case '\"': 
            case '\'': {
                closed = false;
                escaped = false;
                while (end < limit) {
                    if ((ch2 = buf[end++]) == ch && !escaped) {
                        closed = true;
                        break;
                    }
                    if (JsLexer.isJsLineSeparator(ch2)) break;
                    escaped = escaped == false && ch2 == '\\';
                }
                if (!closed) {
                    throw new ParseException(new Message((MessageTypeInt)MessageType.UNTERMINATED_STRING_TOKEN, new MessagePart[]{this.p.filePositionForOffsets(start, end)}));
                }
                type = JsTokenType.STRING;
                break;
            }
            case '/': {
                if (end == limit) {
                    type = JsTokenType.PUNCTUATION;
                    break;
                }
                ch2 = buf[end];
                switch (ch2) {
                    case '/': {
                        for (end = start + 1; end < limit && !JsLexer.isJsLineSeparator(buf[end]); ++end) {
                        }
                        type = JsTokenType.COMMENT;
                        break block0;
                    }
                    case '*': {
                        star = false;
                        closed = false;
                        while (++end < limit) {
                            ch2 = buf[end];
                            if (star && '/' == ch2) {
                                closed = true;
                                ++end;
                                break;
                            }
                            star = ch2 == '*' && this.tokenBreak(end) == false;
                        }
                        if (!closed) {
                            throw new ParseException(new Message((MessageTypeInt)MessageType.UNTERMINATED_STRING_TOKEN, new MessagePart[]{this.p.filePositionForOffsets(start, this.p.getOffset())}));
                        }
                        type = JsTokenType.COMMENT;
                        break block0;
                    }
                }
                if (this.lastNonCommentToken != null && !JsLexer.isRegexp(this.lastNonCommentToken.text)) ** GOTO lbl87
                closed = false;
                escaped = false;
                inCharSet = false;
                block20: while (!JsLexer.isJsLineSeparator(ch2 = buf[end])) {
                    if (escaped) ** GOTO lbl78
                    switch (ch2) {
                        case '/': {
                            if (!inCharSet) {
                                closed = true;
                                ++end;
                                break block20;
                            }
                            ** GOTO lbl79
                        }
                        case '[': {
                            inCharSet = true;
                            break;
                        }
                        case ']': {
                            inCharSet = false;
                            break;
                        }
                        case '\\': {
                            escaped = true;
                        }
                    }
                    ** GOTO lbl79
lbl78:
                    // 1 sources

                    escaped = false;
lbl79:
                    // 3 sources

                    if (++end < limit) continue;
                }
                if (!closed) {
                    throw new ParseException(new Message((MessageTypeInt)MessageType.UNTERMINATED_STRING_TOKEN, new MessagePart[]{this.p.filePositionForOffsets(start, end)}));
                }
                while (end < limit && Character.isLetter(buf[end])) {
                    ++end;
                }
                type = JsTokenType.REGEXP;
                break;
lbl87:
                // 1 sources

                end = this.processPunctuation(start, end);
                type = JsTokenType.PUNCTUATION;
                break;
            }
            case '.': {
                if (end < limit && buf[end] >= '0' && buf[end] <= '9') {
                    pn = this.processNumber(this.p, start, end);
                    end = pn.end;
                    type = pn.type;
                    break;
                }
                end = this.processPunctuation(start, end);
                type = JsTokenType.PUNCTUATION;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                pn = this.processNumber(this.p, start, end);
                end = pn.end;
                type = pn.type;
                break;
            }
            default: {
                if (this.punctuation.contains(ch)) {
                    end = this.processPunctuation(start, end);
                    type = JsTokenType.PUNCTUATION;
                    break;
                }
                v0 = isQuasi = this.isQuasiliteral != false && buf[start] == '@';
                while (end < limit) {
                    ch2 = buf[end];
                    if (isQuasi && (ch2 == '*' || ch2 == '+' || ch2 == '?')) {
                        ++end;
                        break;
                    }
                    if (JsLexer.isJsSpace(ch2) || this.tokenBreak(end) || '\'' == ch2 || '\"' == ch2 || this.punctuation.contains(ch2)) break;
                    ++end;
                }
                type = JsTokenType.WORD;
            }
        }
        pos = this.p.filePositionForOffsets(start, end);
        this.p.consumeTo(end);
        return Token.instance(this.p.toString(start, end), type, pos);
    }

    private ParsedNumber processNumber(CharProducer p, int start, int end) {
        NumberRecognizer nr = new NumberRecognizer(this.punctuation, p);
        for (int i = start; i < end; ++i) {
            if (nr.recognize(i)) continue;
            return new ParsedNumber(nr.getTokenType(), end);
        }
        int limit = p.getLimit();
        while (end < limit && nr.recognize(end)) {
            ++end;
        }
        return new ParsedNumber(nr.getTokenType(), end);
    }

    private int processPunctuation(int start, int end) {
        char ch;
        PunctuationTrie<?> t2;
        PunctuationTrie<?> t = this.punctuation;
        char[] buf = this.p.getBuffer();
        int limit = this.p.getLimit();
        for (int i = start; i < end; ++i) {
            t = t.lookup(buf[i]);
        }
        assert (t.isTerminal());
        while (end < limit && null != (t2 = t.lookup(ch = buf[end])) && t2.isTerminal() && !this.tokenBreak(end)) {
            ++end;
            t = t2;
        }
        return end;
    }

    private boolean tokenBreak(int offset) {
        if (offset == this.p.getLimit()) {
            return false;
        }
        int nUnderlyingChars = this.p.getUnderlyingOffset(offset + 1) - this.p.getUnderlyingOffset(offset);
        return nUnderlyingChars != 1;
    }

    DecodingCharProducer lineContinuingCharProducer(CharProducer p) {
        return DecodingCharProducer.make(new DecodingCharProducer.Decoder(){

            void decode(char[] chars, int offset, int limit) {
                int end = offset;
                while (end + 1 < limit && chars[end] == '\\' && (chars[end + 1] == '\r' || chars[end + 1] == '\n')) {
                    if (chars[end + 1] == '\r' && chars[end + 2] < limit && chars[end + 2] == '\n') {
                        end += 3;
                        continue;
                    }
                    end += 2;
                }
                if (end == offset) {
                    this.end = offset + 1;
                    this.codePoint = chars[offset];
                } else if (end <= limit) {
                    this.end = end + 1;
                    this.codePoint = chars[end];
                } else {
                    this.end = end;
                    this.codePoint = 10;
                }
            }
        }, p);
    }

    static final class ParsedNumber {
        final JsTokenType type;
        final int end;

        ParsedNumber(JsTokenType type, int end) {
            this.type = type;
            this.end = end;
        }
    }
}

