/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Token;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ChildNodes;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.Visitor;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.Join;
import com.google.caja.util.SyntheticAttributeKey;
import com.google.caja.util.SyntheticAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParseTreeNode
implements MutableParseTreeNode {
    private FilePosition pos;
    private List<Token<?>> comments = Collections.emptyList();
    private SyntheticAttributes attributes;
    private ChildNodes<ParseTreeNode> children;

    protected <T extends ParseTreeNode> List<? extends T> childrenAs(Class<T> clazz) {
        return this.children.as(clazz).getImmutableFacet();
    }

    protected AbstractParseTreeNode(FilePosition pos) {
        this(pos, ParseTreeNode.class);
    }

    protected AbstractParseTreeNode(FilePosition pos, Class<? extends ParseTreeNode> childClass) {
        assert (pos != null && childClass != null);
        this.children = new ChildNodes<ParseTreeNode>(childClass);
        this.pos = pos;
    }

    @Override
    public FilePosition getFilePosition() {
        return this.pos;
    }

    public void setFilePosition(FilePosition pos) {
        assert (pos != null);
        this.pos = pos;
    }

    @Override
    public List<Token<?>> getComments() {
        return this.comments;
    }

    @Override
    public List<? extends ParseTreeNode> children() {
        return this.children.getImmutableFacet();
    }

    protected <T2> List<T2> childrenPart(int start, int end, Class<T2> cl) {
        List<ParseTreeNode> sub = this.children.getImmutableFacet().subList(start, end);
        for (ParseTreeNode el : sub) {
            if (cl.isInstance(el)) continue;
            throw new ClassCastException("element not an instance of " + cl + " : " + (null != el ? el.getClass() : "<null>"));
        }
        return Collections.unmodifiableList(sub);
    }

    @Override
    public abstract Object getValue();

    @Override
    public SyntheticAttributes getAttributes() {
        if (null == this.attributes) {
            this.attributes = new SyntheticAttributes();
        }
        return this.attributes;
    }

    public void setComments(List<? extends Token> comments) {
        List<? extends Token> tokens = comments;
        this.comments = !comments.isEmpty() ? Collections.unmodifiableList(new ArrayList<Token>(tokens)) : Collections.emptyList();
    }

    @Override
    public void replaceChild(ParseTreeNode replacement, ParseTreeNode child) {
        this.createMutation().replaceChild(replacement, child).execute();
    }

    @Override
    public void insertBefore(ParseTreeNode toAdd, ParseTreeNode before) {
        this.createMutation().insertBefore(toAdd, before).execute();
    }

    @Override
    public void appendChild(ParseTreeNode toAppend) {
        this.insertBefore(toAppend, null);
    }

    @Override
    public void removeChild(ParseTreeNode toRemove) {
        this.createMutation().removeChild(toRemove).execute();
    }

    @Override
    public MutableParseTreeNode.Mutation createMutation() {
        return new MutationImpl();
    }

    private void setChild(int i, ParseTreeNode child) {
        this.children.getMutableFacet().set(i, child);
    }

    private void addChild(int i, ParseTreeNode child) {
        this.children.getMutableFacet().add(i, child);
    }

    private void copyOnWrite() {
        this.children = new ChildNodes<ParseTreeNode>(this.children);
    }

    private int indexOf(ParseTreeNode child) {
        return this.children.getImmutableFacet().indexOf(child);
    }

    protected void childrenChanged() {
        if (this.children.getImmutableFacet().contains(null)) {
            throw new NullPointerException();
        }
    }

    protected void formatSelf(MessageContext context, int depth, Appendable out) throws IOException {
        out.append(this.getClass().getSimpleName());
        Object value = this.getValue();
        if (null != value) {
            out.append(" : ");
            if (value instanceof MessagePart) {
                ((MessagePart)value).format(context, out);
            } else {
                out.append(value.toString());
            }
        }
        if (!context.relevantKeys.isEmpty() && null != this.attributes) {
            for (SyntheticAttributeKey<?> k : context.relevantKeys) {
                if (!this.attributes.containsKey(k)) continue;
                out.append(" ; ").append(k.getName()).append('=');
                Object attribValue = this.attributes.get(k);
                if (attribValue instanceof MessagePart) {
                    String keyValue;
                    StringBuilder sb = new StringBuilder();
                    ((MessagePart)attribValue).format(context, sb);
                    CharSequence[] lines = sb.toString().split("\n");
                    if (lines.length == 1) {
                        keyValue = lines[0];
                    } else {
                        sb.setLength(0);
                        sb.append("\n    ");
                        int i = depth;
                        while (--i >= 0) {
                            sb.append("  ");
                        }
                        String prefix = sb.toString();
                        sb.setLength(0);
                        sb.append('(');
                        sb.append(Join.join((CharSequence)prefix, lines));
                        sb.append(')');
                        keyValue = sb.toString();
                    }
                    out.append(keyValue);
                    continue;
                }
                out.append(String.valueOf(attribValue));
            }
        }
    }

    @Override
    public void format(MessageContext context, Appendable out) throws IOException {
        this.formatTree(context, out);
    }

    public final void formatTree(MessageContext context, Appendable out) throws IOException {
        this.formatTree(context, 0, out);
    }

    @Override
    public final void formatTree(MessageContext context, int depth, Appendable out) throws IOException {
        int d = depth;
        while (--d >= 0) {
            out.append("  ");
        }
        this.formatSelf(context, depth, out);
        for (ParseTreeNode parseTreeNode : this.children()) {
            out.append("\n");
            parseTreeNode.formatTree(context, depth + 1, out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.formatSelf(new MessageContext(), 0, sb);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)"StringBuilders shouldn't throw IOExceptions");
        }
        return sb.toString();
    }

    public String toStringDeep() {
        return this.toStringDeep(0);
    }

    public String toStringDeep(int d) {
        StringBuilder sb = new StringBuilder();
        try {
            this.formatTree(new MessageContext(), d, sb);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)"StringBuilders shouldn't throw IOExceptions");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean visitChildren(Visitor v, AncestorChain<?> ancestors, TraversalType traversalType) {
        if (this.children.getImmutableFacet().isEmpty()) {
            return true;
        }
        boolean result = true;
        ChildNodes<ParseTreeNode> childrenCache = this.children;
        ParseTreeNode next = childrenCache.getImmutableFacet().get(0);
        int i = 0;
        while (i < childrenCache.getImmutableFacet().size()) {
            if (childrenCache != this.children) {
                int j = this.children.getImmutableFacet().lastIndexOf(next);
                if (j < 0) {
                    int k = i;
                    while (--k >= 0 && (j = this.children.getImmutableFacet().lastIndexOf(childrenCache.getImmutableFacet().get(k))) < 0) {
                    }
                    if (j >= 0 && j + 1 < this.children.getImmutableFacet().size()) {
                        ++j;
                    } else {
                        for (k = i + 1; k < childrenCache.getImmutableFacet().size() && (j = this.children.getImmutableFacet().lastIndexOf(childrenCache.getImmutableFacet().get(k))) < 0; ++k) {
                        }
                        if (j < 0) {
                            return result;
                        }
                    }
                }
                i = j;
                childrenCache = this.children;
                next = childrenCache.getImmutableFacet().get(i);
            }
            ParseTreeNode child = next;
            next = i + 1 < childrenCache.getImmutableFacet().size() ? childrenCache.getImmutableFacet().get(i + 1) : null;
            switch (traversalType) {
                case PREORDER: {
                    child.acceptPreOrder(v, ancestors);
                    break;
                }
                case POSTORDER: {
                    if (child.acceptPostOrder(v, ancestors)) break;
                    return false;
                }
            }
            ++i;
        }
        return result;
    }

    private boolean stillInParent(AncestorChain<?> ancestors) {
        return ancestors == null || ancestors.node.children().contains(this);
    }

    @Override
    public final boolean acceptPreOrder(Visitor v, AncestorChain<?> ancestors) {
        if (!v.visit(ancestors = AncestorChain.instance(ancestors, this))) {
            return false;
        }
        if (!this.stillInParent(ancestors.parent)) {
            return true;
        }
        this.visitChildren(v, ancestors, TraversalType.PREORDER);
        return true;
    }

    @Override
    public final boolean acceptPostOrder(Visitor v, AncestorChain<?> ancestors) {
        if (!this.visitChildren(v, ancestors = AncestorChain.instance(ancestors, this), TraversalType.POSTORDER)) {
            return false;
        }
        if (this.stillInParent(ancestors.parent)) {
            return v.visit(ancestors);
        }
        return true;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    @Override
    public ParseTreeNode clone() {
        ArrayList<ParseTreeNode> clonedChildren = new ArrayList<ParseTreeNode>(this.children.getImmutableFacet().size());
        for (ParseTreeNode child : this.children.getImmutableFacet()) {
            clonedChildren.add(child.clone());
        }
        AbstractParseTreeNode cloned = (AbstractParseTreeNode)ParseTreeNodes.newNodeInstance(this.getClass(), this.getFilePosition(), this.getValue(), clonedChildren);
        if (this.attributes != null) {
            cloned.attributes = new SyntheticAttributes(this.attributes);
        }
        return cloned;
    }

    private final class Insertion
    extends Change {
        private final ParseTreeNode toAdd;
        private final ParseTreeNode before;

        Insertion(ParseTreeNode toAdd, ParseTreeNode before) {
            this.toAdd = toAdd;
            this.before = before;
        }

        boolean apply(boolean copied) {
            int childIndex;
            if (null == this.before) {
                childIndex = AbstractParseTreeNode.this.children.getImmutableFacet().size();
            } else {
                childIndex = AbstractParseTreeNode.this.indexOf(this.before);
                if (childIndex < 0) {
                    throw new NoSuchElementException("Child not in parent");
                }
                if (!copied) {
                    AbstractParseTreeNode.this.copyOnWrite();
                    copied = true;
                }
            }
            this.backupIndex = childIndex;
            AbstractParseTreeNode.this.addChild(childIndex, this.toAdd);
            return copied;
        }

        void rollback() {
            int childIndex = this.backupIndex;
            ParseTreeNode removed = (ParseTreeNode)AbstractParseTreeNode.this.children.getMutableFacet().remove(childIndex);
            if (removed != this.toAdd) {
                AbstractParseTreeNode.this.setChild(childIndex, removed);
                throw new IllegalStateException();
            }
        }
    }

    private final class Removal
    extends Change {
        private final ParseTreeNode toRemove;

        Removal(ParseTreeNode toRemove) {
            this.toRemove = toRemove;
        }

        boolean apply(boolean copied) {
            int childIndex;
            if (!copied) {
                AbstractParseTreeNode.this.copyOnWrite();
            }
            if ((childIndex = AbstractParseTreeNode.this.indexOf(this.toRemove)) < 0) {
                throw new NoSuchElementException("child not in parent");
            }
            this.backupIndex = childIndex;
            AbstractParseTreeNode.this.children.getMutableFacet().remove(childIndex);
            return true;
        }

        void rollback() {
            if (AbstractParseTreeNode.this.children.getImmutableFacet().contains(this.toRemove)) {
                return;
            }
            AbstractParseTreeNode.this.addChild(this.backupIndex, this.toRemove);
        }
    }

    private final class Replacement
    extends Change {
        private final ParseTreeNode replacement;
        private final ParseTreeNode replaced;

        Replacement(ParseTreeNode replacement, ParseTreeNode replaced) {
            this.replacement = replacement;
            this.replaced = replaced;
        }

        boolean apply(boolean copied) {
            int childIndex;
            if (!copied) {
                AbstractParseTreeNode.this.copyOnWrite();
            }
            if ((childIndex = AbstractParseTreeNode.this.indexOf(this.replaced)) < 0) {
                throw new NoSuchElementException("Node to replace is not a child of this node.");
            }
            if (AbstractParseTreeNode.this.indexOf(this.replacement) >= 0) {
                throw new NoSuchElementException("Node to add is already a child of this node.");
            }
            this.backupIndex = childIndex;
            AbstractParseTreeNode.this.setChild(childIndex, this.replacement);
            return true;
        }

        void rollback() {
            int childIndex = this.backupIndex;
            if (AbstractParseTreeNode.this.children.getImmutableFacet().contains(this.replaced)) {
                return;
            }
            AbstractParseTreeNode.this.setChild(childIndex, this.replaced);
        }
    }

    private abstract class Change {
        int backupIndex = -1;

        private Change() {
        }

        abstract boolean apply(boolean var1);

        abstract void rollback();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MutationImpl
    implements MutableParseTreeNode.Mutation {
        private List<Change> changes = new ArrayList<Change>();

        private MutationImpl() {
        }

        @Override
        public MutableParseTreeNode.Mutation replaceChild(ParseTreeNode replacement, ParseTreeNode child) {
            this.changes.add(new Replacement(replacement, child));
            return this;
        }

        @Override
        public MutableParseTreeNode.Mutation insertBefore(ParseTreeNode toAdd, ParseTreeNode before) {
            this.changes.add(new Insertion(toAdd, before));
            return this;
        }

        @Override
        public MutableParseTreeNode.Mutation appendChild(ParseTreeNode toAppend) {
            return this.insertBefore(toAppend, null);
        }

        @Override
        public MutableParseTreeNode.Mutation appendChildren(Iterable<? extends ParseTreeNode> nodes) {
            for (ParseTreeNode parseTreeNode : nodes) {
                this.changes.add(new Insertion(parseTreeNode, null));
            }
            return this;
        }

        @Override
        public MutableParseTreeNode.Mutation removeChild(ParseTreeNode toRemove) {
            this.changes.add(new Removal(toRemove));
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            boolean copied = false;
            for (Change change : this.changes) {
                copied = change.apply(copied);
            }
            try {
                AbstractParseTreeNode.this.childrenChanged();
            }
            catch (RuntimeException ex) {
                int i = this.changes.size();
                while (--i >= 0) {
                    this.changes.get(i).rollback();
                }
                try {
                    AbstractParseTreeNode.this.childrenChanged();
                }
                finally {
                    throw ex;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TraversalType {
        PREORDER,
        POSTORDER;

    }
}

