/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.render.SideBySideRenderer;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.Callback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularSideBySideRenderer
extends SideBySideRenderer {
    private final List<TableRow> rows = new ArrayList<TableRow>();
    private final MessageContext mc;
    private final Appendable out;
    private final Callback<IOException> exHandler;
    private boolean closed = false;

    public TabularSideBySideRenderer(Map<InputSource, ? extends CharSequence> originalSource, MessageContext mc, Appendable out, Callback<IOException> exHandler) {
        super(originalSource);
        if (out == null) {
            throw new NullPointerException();
        }
        this.mc = mc;
        this.out = out;
        this.exHandler = exHandler;
    }

    @Override
    protected TokenConsumer makeRenderer(StringBuilder sb) {
        return new JsPrettyPrinter(new Concatenator(sb));
    }

    @Override
    protected void emitLine(FilePosition pos, String orig, String rendered) {
        int i;
        String[] origLines = TabularSideBySideRenderer.splitLines(TabularSideBySideRenderer.trimNewlines(orig));
        String[] renderedLines = TabularSideBySideRenderer.splitLines(TabularSideBySideRenderer.trimNewlines(rendered));
        int n = Math.min(origLines.length, renderedLines.length);
        for (i = 0; i < n; ++i) {
            this.rows.add(new CodeRow(origLines[i], renderedLines[i]));
        }
        for (i = n; i < origLines.length; ++i) {
            this.rows.add(new CodeRow(origLines[i], ""));
        }
        for (i = n; i < renderedLines.length; ++i) {
            this.rows.add(new CodeRow("", renderedLines[i]));
        }
    }

    @Override
    protected void switchSource(InputSource prev, InputSource next) {
        this.rows.add(new FileRow(this.mc.abbreviate(next)));
    }

    @Override
    public void noMoreTokens() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.noMoreTokens();
        try {
            int[] widths = TabularSideBySideRenderer.layoutRows(this.rows);
            for (TableRow row : this.rows) {
                this.out.append(row.toString(widths)).append('\n');
            }
        }
        catch (IOException ex) {
            this.exHandler.handle(ex);
        }
    }

    private static int[] layoutRows(List<TableRow> rows) {
        int nCols = 0;
        for (TableRow row : rows) {
            nCols = Math.max(nCols, row.nCols());
        }
        int[] widths = new int[nCols];
        for (int n = nCols; n > 0; --n) {
            int spaceToRight = 0;
            int i = nCols;
            while (--i >= n) {
                spaceToRight += widths[i];
            }
            for (TableRow row : rows) {
                if (n != row.nCols()) continue;
                for (int i2 = 0; i2 < n; ++i2) {
                    widths[i2] = Math.max(widths[i2], row.minWidth(i2) - spaceToRight);
                }
            }
        }
        return widths;
    }

    private static String[] splitLines(String s) {
        if ("".equals(s)) {
            return new String[0];
        }
        return s.split("\r\n?|\n");
    }

    private static String trimNewlines(String s) {
        char ch;
        int start;
        int end = s.length();
        for (start = 0; start < end && ((ch = s.charAt(start)) == '\r' || ch == '\n'); ++start) {
        }
        while (end > start && ((ch = s.charAt(end - 1)) == '\r' || ch == '\n')) {
            --end;
        }
        return s.substring(start, end);
    }

    private static class FileRow
    implements TableRow {
        private final String path;

        FileRow(String path) {
            this.path = path;
        }

        public int nCols() {
            return 1;
        }

        public int minWidth(int col) {
            return this.path.length() + 6;
        }

        public String toString(int[] colWidths) {
            int width = 0;
            for (int w : colWidths) {
                width += w;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("/*");
            int padding = width - 6 - this.path.length();
            int i = padding / 2;
            while (--i >= 0) {
                sb.append('*');
            }
            sb.append(' ').append(this.path).append(' ');
            i = padding - padding / 2;
            while (--i >= 0) {
                sb.append('*');
            }
            sb.append("*/");
            return sb.toString();
        }
    }

    private static class CodeRow
    implements TableRow {
        private final String orig;
        private final String rendered;

        CodeRow(String orig, String rendered) {
            this.orig = orig;
            this.rendered = rendered;
        }

        public int nCols() {
            return 2;
        }

        public int minWidth(int col) {
            return (col == 0 ? this.origString(0) + 1 : this.renderedString(0)).toString().length();
        }

        String origString(int minWidth) {
            StringBuilder sb = new StringBuilder();
            sb.append("/* ");
            sb.append(this.orig.replaceAll("[\\p{javaIdentifierIgnorable}]", "\ufffd").replace('@', '\ufffd').replace("*/", "\ufffd/").replace("<!", "<\ufffd").replace("-->", "-\ufffd>").replace("<!", "<\ufffd").replace("]]>", "]\ufffd>").replace("</", "<\ufffd"));
            while (sb.length() < minWidth - 4) {
                sb.append(' ');
            }
            sb.append(" */");
            return sb.toString();
        }

        String renderedString(int minWidth) {
            return this.rendered;
        }

        public String toString(int[] colWidths) {
            String col0 = this.origString(colWidths[0]);
            String col1 = this.renderedString(colWidths[1]);
            return "".equals(col1) ? col0 : col0 + " " + col1;
        }
    }

    private static interface TableRow {
        public int nCols();

        public int minWidth(int var1);

        public String toString(int[] var1);
    }
}

