/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.restlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;

@Name(value="previewRestlet")
@Scope(value=ScopeType.EVENT)
public class PreviewRestlet
extends BaseNuxeoRestlet {
    private static final Log log = LogFactory.getLog(PreviewRestlet.class);
    @In(create=true)
    protected NavigationContext navigationContext;
    protected CoreSession documentManager;
    protected DocumentModel targetDocument;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    protected static final List<String> previewInProcessing = Collections.synchronizedList(new ArrayList());

    public void handle(Request req, Response res) {
        List<Blob> previewBlobs;
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String xpath = (String)req.getAttributes().get("fieldPath");
        xpath = xpath.replace("-", "/");
        List segments = req.getResourceRef().getSegments();
        StringBuilder sb = new StringBuilder();
        for (int i = 6; i < segments.size(); ++i) {
            sb.append((String)segments.get(i));
            sb.append("/");
        }
        String subPath = sb.substring(0, sb.length() - 1);
        try {
            xpath = URLDecoder.decode(xpath, "UTF-8");
            subPath = URLDecoder.decode(subPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        String blobPostProcessingParameter = PreviewRestlet.getQueryParamValue((Request)req, (String)"blobPostProcessing", (String)"false");
        boolean blobPostProcessing = Boolean.parseBoolean(blobPostProcessingParameter);
        if (repo == null || repo.equals("*")) {
            PreviewRestlet.handleError((Response)res, (String)"you must specify a repository");
            return;
        }
        if (docid == null || repo.equals("*")) {
            PreviewRestlet.handleError((Response)res, (String)"you must specify a documentId");
            return;
        }
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            this.targetDocument = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
        }
        catch (ClientException e) {
            PreviewRestlet.handleError((Response)res, (Exception)((Object)e));
            return;
        }
        this.localeSetup(req);
        try {
            previewBlobs = this.initCachedBlob(res, xpath, blobPostProcessing);
        }
        catch (Exception e) {
            PreviewRestlet.handleError((Response)res, (String)"unable to get preview");
            return;
        }
        if (previewBlobs == null || previewBlobs.isEmpty()) {
            return;
        }
        HttpServletResponse response = PreviewRestlet.getHttpResponse((Response)res);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        try {
            if (subPath == null || "".equals(subPath)) {
                this.handlePreview(res, previewBlobs.get(0), "text/html");
                return;
            }
            for (Blob blob : previewBlobs) {
                if (!subPath.equals(blob.getFilename())) continue;
                this.handlePreview(res, blob, blob.getMimeType());
                return;
            }
        }
        catch (IOException e) {
            PreviewRestlet.handleError((Response)res, (Exception)e);
        }
    }

    private void localeSetup(Request req) {
        Locale locale = null;
        try {
            locale = ((LocaleProvider)Framework.getLocalService(LocaleProvider.class)).getLocale(this.documentManager);
        }
        catch (ClientException e) {
            log.warn((Object)"Couldn't get locale from LocaleProvider, trying request locale and default locale", (Throwable)e);
        }
        if (locale == null) {
            locale = PreviewRestlet.getHttpRequest((Request)req).getLocale();
        }
        this.localeSelector.setLocale(locale);
    }

    private List<Blob> initCachedBlob(Response res, String xpath, boolean blobPostProcessing) throws ClientException {
        HtmlPreviewAdapter preview = null;
        if (preview == null) {
            preview = (HtmlPreviewAdapter)this.targetDocument.getAdapter(HtmlPreviewAdapter.class);
        }
        if (preview == null) {
            this.handleNoPreview(res, xpath, null);
            return null;
        }
        List<Blob> previewBlobs = null;
        try {
            previewBlobs = xpath.equals("default") ? preview.getFilePreviewBlobs(blobPostProcessing) : preview.getFilePreviewBlobs(xpath, blobPostProcessing);
        }
        catch (PreviewException e) {
            previewInProcessing.remove(this.targetDocument.getId());
            this.handleNoPreview(res, xpath, (Exception)((Object)e));
            return null;
        }
        if (previewBlobs == null || previewBlobs.size() == 0) {
            this.handleNoPreview(res, xpath, null);
            return null;
        }
        return previewBlobs;
    }

    protected void handleNoPreview(Response res, String xpath, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><center><h1>");
        if (e == null) {
            sb.append((String)this.resourcesAccessor.getMessages().get("label.not.available.preview") + "</h1>");
        } else {
            sb.append((String)this.resourcesAccessor.getMessages().get("label.cannot.generated.preview") + "</h1>");
            sb.append("<pre>Technical issue:</pre>");
            sb.append("<pre>Blob path: ");
            sb.append(xpath);
            sb.append("</pre>");
            sb.append("<pre>");
            sb.append(e.toString());
            sb.append("</pre>");
        }
        sb.append("</center></body></html>");
        log.error((Object)("could not build preview for missing blob at " + xpath), (Throwable)e);
        res.setEntity(sb.toString(), MediaType.TEXT_HTML);
        HttpServletResponse response = PreviewRestlet.getHttpResponse((Response)res);
        response.setHeader("Content-Disposition", "inline");
    }

    protected void handlePreview(Response res, Blob previewBlob, String mimeType) throws IOException {
        final File tempfile = File.createTempFile("nuxeo-previewrestlet-tmp", "");
        tempfile.deleteOnExit();
        previewBlob.transferTo(tempfile);
        res.setEntity((Representation)new OutputRepresentation(null){

            public void write(OutputStream outputStream) throws IOException {
                FileInputStream instream = new FileInputStream(tempfile);
                FileUtils.copy((InputStream)instream, (OutputStream)outputStream);
                instream.close();
                tempfile.delete();
            }
        });
        HttpServletResponse response = PreviewRestlet.getHttpResponse((Response)res);
        response.setHeader("Content-Disposition", "inline");
        response.setContentType(mimeType);
    }
}

