/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.action;

import java.util.HashMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageAction;
import org.nuxeo.runtime.api.Framework;

public class CheckSenderAction
implements MessageAction {
    private static final Log log = LogFactory.getLog(CheckSenderAction.class);

    @Override
    public boolean execute(ExecutionContext context) throws Exception {
        Message message = context.getMessage();
        Address[] addresses = message.getFrom();
        if (addresses == null || addresses.length == 0 || !(addresses[0] instanceof InternetAddress)) {
            log.debug((Object)("No internet messages, stopping the pipe: " + message));
            return false;
        }
        InternetAddress address = (InternetAddress)addresses[0];
        String principal = CheckSenderAction.getPrincipal(address.getAddress());
        if (principal == null) {
            log.debug((Object)"Sender not in user directory. Stop processing");
            return false;
        }
        context.put("sender", principal);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPrincipal(String address) throws Exception {
        Session session = null;
        String principal = null;
        try {
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            session = directoryService.open("userDirectory");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("email", address);
            DocumentModelList list = session.query(map);
            if (list == null || list.isEmpty()) {
                log.debug((Object)("Stopping pipe, address: " + address + " return " + list));
                String string = null;
                return string;
            }
            DocumentModel dm = (DocumentModel)list.get(0);
            principal = dm.getId();
        }
        finally {
            session.close();
        }
        return principal;
    }

    @Override
    public void reset(ExecutionContext context) throws Exception {
    }
}

