/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.consumers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth.consumers.NuxeoOAuthConsumer;
import org.nuxeo.ecm.platform.oauth.consumers.OAuthConsumerRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuthConsumerRegistryImpl
extends DefaultComponent
implements OAuthConsumerRegistry {
    protected static final Log log = LogFactory.getLog(OAuthConsumerRegistryImpl.class);
    public static final String DIRECTORY_NAME = "oauthConsumers";

    @Override
    public NuxeoOAuthConsumer getConsumer(String consumerKey, String keyType) {
        try {
            NuxeoOAuthConsumer consumer = this.getEntry(consumerKey, keyType);
            return consumer;
        }
        catch (Exception e) {
            log.error((Object)("Unable to read consumer " + consumerKey + " from Directory backend"), (Throwable)e);
            return null;
        }
    }

    @Override
    public NuxeoOAuthConsumer getConsumer(String consumerKey) {
        return this.getConsumer(consumerKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NuxeoOAuthConsumer getEntry(String consumerKey, String keyType) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        Session session = null;
        try {
            NuxeoOAuthConsumer consumer;
            session = ds.open(DIRECTORY_NAME);
            DocumentModel entry = session.getEntry(consumerKey);
            if (entry == null) {
                NuxeoOAuthConsumer nuxeoOAuthConsumer = null;
                return nuxeoOAuthConsumer;
            }
            NuxeoOAuthConsumer nuxeoOAuthConsumer = consumer = NuxeoOAuthConsumer.createFromDirectoryEntry(entry, keyType);
            return nuxeoOAuthConsumer;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NuxeoOAuthConsumer storeConsumer(NuxeoOAuthConsumer consumer) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        Session session = null;
        try {
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, String> init = new HashMap<String, String>();
            init.put("consumerKey", consumer.consumerKey);
            DocumentModel entry = session.createEntry(init);
            consumer.asDocumentModel(entry);
            session.updateEntry(entry);
            session.commit();
            if (entry == null) {
                NuxeoOAuthConsumer nuxeoOAuthConsumer = null;
                return nuxeoOAuthConsumer;
            }
            NuxeoOAuthConsumer nuxeoOAuthConsumer = consumer = NuxeoOAuthConsumer.createFromDirectoryEntry(entry, null);
            return nuxeoOAuthConsumer;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConsumer(String consumerKey) {
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            Session session = null;
            try {
                session = ds.open(DIRECTORY_NAME);
                session.deleteEntry(consumerKey);
                session.commit();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to delete consumer " + consumerKey), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NuxeoOAuthConsumer> listConsumers() {
        ArrayList<NuxeoOAuthConsumer> result = new ArrayList<NuxeoOAuthConsumer>();
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            Session session = null;
            try {
                session = ds.open(DIRECTORY_NAME);
                DocumentModelList entries = session.getEntries();
                for (DocumentModel entry : entries) {
                    result.add(NuxeoOAuthConsumer.createFromDirectoryEntry(entry, null));
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while fetching consumer directory", (Throwable)e);
        }
        return result;
    }
}

