/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.virtualnavigation.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.virtualnavigation.action.NavTreeDescriptor;
import org.nuxeo.ecm.virtualnavigation.service.NavTreeService;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeManager;
import org.nuxeo.ecm.webapp.seam.NuxeoSeamHotReloader;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.service.TimestampedService;

@Name(value="multiNavTreeManager")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class MultiNavTreeManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String STD_NAV_TREE = "CONTENT_TREE";
    public static final String STD_NAV_TREE_LABEL = "label.content.tree";
    protected List<NavTreeDescriptor> availableNavigationTrees;
    protected Long availableNavigationTreesTimestamp;
    protected String selectedNavigationTree;
    protected String thePath = "";
    @In(required=false, create=true)
    protected DirectoryTreeManager directoryTreeManager;
    @In(create=true)
    protected NuxeoSeamHotReloader seamReload;
    @In(create=true)
    protected Map<String, String> messages;

    public List<NavTreeDescriptor> getAvailableNavigationTrees() {
        if (this.availableNavigationTrees == null || this.shouldResetCache()) {
            this.availableNavigationTrees = new ArrayList<NavTreeDescriptor>();
            this.availableNavigationTrees.add(new NavTreeDescriptor(STD_NAV_TREE, STD_NAV_TREE_LABEL));
            NavTreeService navTreeService = (NavTreeService)((Object)Framework.getLocalService(NavTreeService.class));
            this.availableNavigationTrees.addAll(navTreeService.getTreeDescriptors());
            this.availableNavigationTreesTimestamp = navTreeService.getLastModified();
        }
        return this.availableNavigationTrees;
    }

    protected boolean shouldResetCache() {
        NavTreeService navTreeService = (NavTreeService)((Object)Framework.getLocalService(NavTreeService.class));
        return this.seamReload.isDevModeSet() && this.seamReload.shouldResetCache((TimestampedService)navTreeService, this.availableNavigationTreesTimestamp);
    }

    @Factory(value="selectedNavigationTree", scope=ScopeType.EVENT)
    public String getSelectedNavigationTree() {
        if (this.selectedNavigationTree == null) {
            this.setSelectedNavigationTree(STD_NAV_TREE);
        }
        return this.selectedNavigationTree;
    }

    @Factory(value="selectedNavigationTreeDescriptor", scope=ScopeType.EVENT)
    public NavTreeDescriptor getSelectedNavigationTreeDescriptor() {
        String navTreeName = this.getSelectedNavigationTree();
        for (NavTreeDescriptor desc : this.getAvailableNavigationTrees()) {
            if (!desc.getTreeId().equals(navTreeName)) continue;
            return desc;
        }
        return null;
    }

    public void setSelectedNavigationTree(String selectedNavigationTree) {
        this.directoryTreeManager.setSelectedTreeName(selectedNavigationTree);
        this.selectedNavigationTree = selectedNavigationTree;
        Events.instance().raiseEvent("folderishDocumentSelectionChanged", new Object[]{new DocumentModelImpl("Folder")});
    }

    @Observer(value={"PATH_PROCESSED"}, create=false)
    @BypassInterceptors
    public void setThePath(String myPath) {
        this.thePath = myPath;
    }

    public String getVirtualNavPath() {
        String[] partOfPath = this.thePath.split("/");
        String finalPath = "";
        for (String aPart : partOfPath) {
            finalPath = finalPath + " > " + this.messages.get(aPart);
        }
        return finalPath;
    }
}

