/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.listener;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.mail.AuthenticationFailedException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.mail.utils.MailCoreHelper;
import org.nuxeo.runtime.api.Framework;

public class MailEventListener
implements EventListener {
    public static final String EVENT_NAME = "MailReceivedEvent";
    public static final String PIPE_NAME = "nxmail";
    public static final String INBOX = "INBOX";
    private static final Log log = LogFactory.getLog(MailEventListener.class);
    protected Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        String eventId = event.getName();
        if (!EVENT_NAME.equals(eventId)) {
            return;
        }
        if (this.lock.tryLock()) {
            try {
                this.doHandleEvent(event);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            log.info((Object)"Skip email check since it is already running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doHandleEvent(Event event) {
        CoreSession coreSession;
        LoginContext loginContext;
        block23: {
            block24: {
                block21: {
                    block22: {
                        loginContext = null;
                        coreSession = null;
                        try {
                            loginContext = Framework.login();
                            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                            Repository repository = mgr.getDefaultRepository();
                            if (repository != null) {
                                coreSession = repository.open();
                            }
                            if (coreSession == null) {
                                if (coreSession == null) break block21;
                                break block22;
                            }
                            StringBuilder query = new StringBuilder();
                            query.append("SELECT * FROM MailFolder ");
                            query.append(String.format(" WHERE ecm:currentLifeCycleState != '%s' ", "deleted"));
                            query.append(" AND ecm:isProxy = 0 ");
                            DocumentModelList mailFolderList = coreSession.query(query.toString());
                            log.info((Object)("Checking emails on " + mailFolderList.size() + " mailboxe(s)"));
                            for (DocumentModel currentMailFolder : mailFolderList) {
                                try {
                                    MailCoreHelper.checkMail(currentMailFolder, coreSession);
                                }
                                catch (AuthenticationFailedException e) {
                                    log.warn((Object)"Error connecting to email account", (Throwable)e);
                                }
                            }
                            if (coreSession == null) break block23;
                            break block24;
                        }
                        catch (Exception e) {
                            log.error((Object)"MailEventListener error...", (Throwable)e);
                            return;
                        }
                    }
                    CoreInstance.getInstance().close(coreSession);
                }
                if (loginContext == null) return;
                try {
                    loginContext.logout();
                    return;
                }
                catch (LoginException e) {
                    // empty catch block
                }
                return;
            }
            CoreInstance.getInstance().close(coreSession);
        }
        if (loginContext == null) return;
        try {
            loginContext.logout();
            return;
        }
        catch (LoginException e) {
            return;
        }
        finally {
            if (coreSession != null) {
                CoreInstance.getInstance().close(coreSession);
            }
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {}
            }
        }
    }
}

