/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.common.util.FutureUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="people", path="/{userId}+/{groupId}/{personId}+")
public class PersonHandler {
    private final PersonService personService;
    private final ContainerConfig config;

    @Inject
    public PersonHandler(PersonService personService, ContainerConfig config) {
        this.personService = personService;
        this.config = config;
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        GroupId groupId = request.getGroup();
        ImmutableSet optionalPersonId = ImmutableSet.copyOf((Collection)request.getListParameter("personId"));
        Set fields = request.getFields(Person.Field.DEFAULT_FIELDS);
        Set<UserId> userIds = request.getUsers();
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        if (userIds.size() > 1 && !optionalPersonId.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch personIds for multiple userIds");
        }
        CollectionOptions options = new CollectionOptions((RequestItem)request);
        if (userIds.size() == 1) {
            if (optionalPersonId.isEmpty()) {
                if (groupId.getType() == GroupId.Type.self) {
                    if (options != null && options.getFilter() != null) {
                        Future<RestfulCollection<Person>> people = this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
                        return FutureUtil.getFirstFromCollection(people);
                    }
                    return this.personService.getPerson(userIds.iterator().next(), fields, request.getToken());
                }
                return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
            }
            if (optionalPersonId.size() == 1) {
                ImmutableSet optionalUserIds = ImmutableSet.of((Object)new UserId(UserId.Type.userId, (String)optionalPersonId.iterator().next()));
                Future<RestfulCollection<Person>> people = this.personService.getPeople((Set<UserId>)optionalUserIds, new GroupId(GroupId.Type.self, null), options, fields, request.getToken());
                return FutureUtil.getFirstFromCollection(people);
            }
            ImmutableSet.Builder personIds = ImmutableSet.builder();
            for (String pid : optionalPersonId) {
                personIds.add((Object)new UserId(UserId.Type.userId, pid));
            }
            return this.personService.getPeople((Set<UserId>)personIds.build(), new GroupId(GroupId.Type.self, null), options, fields, request.getToken());
        }
        return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
    }

    @Operation(httpMethods={"GET"}, path="/@supportedFields")
    public List<Object> supportedFields(RequestItem request) {
        String container = PersonHandler.firstNonNull(request.getToken().getContainer(), "default");
        return this.config.getList(container, "${Cur['gadgets.features'].opensocial.supportedFields.person}");
    }

    private static <T> T firstNonNull(T first, T second) {
        return (T)(first != null ? first : Preconditions.checkNotNull(second));
    }
}

