/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api.imageresource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.ImageResource;

public class BlobResource
implements ImageResource {
    private static final long serialVersionUID = 1L;
    protected Blob blob;
    protected String hash;
    protected Calendar modified;

    public BlobResource(Blob blob) {
        this.blob = blob;
        this.hash = blob.getDigest() != null ? blob.getDigest() : this.getMD5Digest();
        this.modified = Calendar.getInstance();
    }

    @Override
    public Blob getBlob() throws ClientException {
        return this.blob;
    }

    @Override
    public String getHash() throws ClientException {
        return this.hash;
    }

    @Override
    public Calendar getModificationDate() throws ClientException {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMD5Digest() {
        String string;
        InputStream in = null;
        try {
            Blob b = this.blob.persist();
            in = b.getStream();
            string = DigestUtils.md5Hex((InputStream)in);
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = this.blob.hashCode() + "fakeHash";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }
}

