/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer.escaping;

import com.google.caja.util.Join;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriUtil {
    private static final Pattern RFC_2396 = Pattern.compile("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$", 32);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static String normalizeUri(String uri) {
        Matcher m = RFC_2396.matcher(uri);
        m.matches();
        String scheme = m.group(1);
        String authority = m.group(2);
        String path = m.group(3);
        String query = m.group(4);
        String fragment = m.group(5);
        StringBuilder sb = new StringBuilder(uri.length());
        if (scheme != null) {
            UriUtil.normalizeScheme(scheme, sb);
            sb.append(':');
        }
        if (authority != null) {
            sb.append("//");
            UriUtil.normalizeAuthority(authority, sb);
        }
        if (path.length() != 0 || sb.length() != 0) {
            UriUtil.normalizePath(path, sb.length() != 0, sb);
        }
        if (query != null) {
            sb.append('?');
            UriUtil.normalizeQuery(query, sb);
        }
        if (fragment != null) {
            sb.append('#');
            UriUtil.normalizeFragment(fragment, sb);
        }
        return sb.toString();
    }

    private static void normalizeScheme(String scheme, StringBuilder out) {
        int pos = 0;
        int n = scheme.length();
        for (int i = 0; i < n; ++i) {
            char ch = scheme.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(scheme, i)) continue;
                out.append(scheme, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '+' || ch == '-' || ch == '.') continue;
            out.append(scheme, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(scheme, pos, n);
    }

    private static void normalizeAuthority(String authority, StringBuilder out) {
        int pos = 0;
        int n = authority.length();
        for (int i = 0; i < n; ++i) {
            char ch = authority.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(authority, i)) continue;
                out.append(authority, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == ':' || ch == '-' || ch == '+' || ch == '.') continue;
            out.append(authority, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(authority, pos, n);
    }

    private static void normalizePath(String path, boolean requireAbsPath, StringBuilder out) {
        String normPath = UriUtil.normalizeEscapesInPath(path);
        boolean isAbs = requireAbsPath;
        if (normPath.startsWith("/")) {
            normPath = normPath.substring(1);
            isAbs = true;
        }
        ArrayList<String> pathParts = new ArrayList<String>(Arrays.asList(normPath.split("/")));
        int i = 0;
        while (i < pathParts.size()) {
            String dottedPart = ((String)pathParts.get(i)).replace("%2e", ".").replace("%2E", ".");
            if (".".equals(dottedPart)) {
                pathParts.remove(i);
                continue;
            }
            if ("..".equals(dottedPart)) {
                if (i > 0 && !"..".equals(pathParts.get(i - 1))) {
                    pathParts.subList(--i, i + 2).clear();
                    continue;
                }
                if (isAbs) {
                    pathParts.remove(i);
                    continue;
                }
                pathParts.set(i, "..");
                ++i;
                continue;
            }
            ++i;
        }
        if (isAbs) {
            out.append('/');
        }
        Join.join(out, (CharSequence)"/", pathParts);
    }

    private static String normalizeEscapesInPath(String path) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char ch = path.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(path, i)) continue;
                sb.append(path, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == ':' || ch == '-' || ch == '+' || ch == '.' || ch == '/' || ch == ',' || ch == '$') continue;
            sb.append(path, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, sb);
        }
        sb.append(path, pos, n);
        return sb.toString();
    }

    private static void normalizeQuery(String query, StringBuilder out) {
        int pos = 0;
        int n = query.length();
        for (int i = 0; i < n; ++i) {
            char ch = query.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(query, i)) continue;
                out.append(query, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '+' || ch == '.' || ch == '=' || ch == '&' || ch == ',') continue;
            out.append(query, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(query, pos, n);
    }

    private static void normalizeFragment(String fragment, StringBuilder out) {
        int pos = 0;
        int n = fragment.length();
        for (int i = 0; i < n; ++i) {
            char ch = fragment.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(fragment, i)) continue;
                out.append(fragment, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '+' || ch == '.') continue;
            out.append(fragment, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(fragment, pos, n);
    }

    private static void pctEncode(char ch, StringBuilder out) {
        if (ch < '\u0080') {
            UriUtil.pctEncode((byte)ch, out);
        } else {
            ByteBuffer bb = UTF8.encode(CharBuffer.wrap(new char[]{ch}));
            while (bb.position() < bb.limit()) {
                UriUtil.pctEncode(bb.get(), out);
            }
        }
    }

    private static void pctEncode(byte b, StringBuilder out) {
        out.append('%').append("0123456789ABCDEF".charAt(b >> 4 & 0xF)).append("0123456789ABCDEF".charAt(b & 0xF));
    }

    private static boolean isInvalidEsc(String uriPart, int pctIdx) {
        return pctIdx + 2 >= uriPart.length() || !UriUtil.isHexDigit(uriPart.charAt(pctIdx + 1)) || !UriUtil.isHexDigit(uriPart.charAt(pctIdx + 2));
    }

    private static boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    private UriUtil() {
    }
}

