/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.util.EJB;

public final class SeamComponentCallHelper {
    private SeamComponentCallHelper() {
    }

    public static Object getSeamComponentByName(String seamName) {
        Component component = Component.forName((String)seamName);
        if (component == null) {
            throw new RuntimeException("No such component: " + seamName);
        }
        Object seamComponent = Component.getInstance((String)seamName, (boolean)true);
        return seamComponent;
    }

    public static Object getSeamComponentByRef(Object seamRef) {
        String seamName = SeamComponentCallHelper.getSeamComponentName(seamRef);
        if (seamName == null) {
            return null;
        }
        return SeamComponentCallHelper.getSeamComponentByName(seamName);
    }

    public static Object callSeamComponentByName(String seamName, String methodName, Object[] params) {
        Method m;
        Object seamComponent = SeamComponentCallHelper.getSeamComponentByName(seamName);
        Component component = Component.forName((String)seamName);
        Class type = null;
        if (component.getType().isSessionBean() && !component.getBusinessInterfaces().isEmpty()) {
            for (Class c : component.getBusinessInterfaces()) {
                if (!c.isAnnotationPresent(EJB.LOCAL)) continue;
                type = (Class)component.getBusinessInterfaces().iterator().next();
                break;
            }
            if (type == null) {
                throw new RuntimeException("Type cannot be determined for component [" + component + "]. Please ensure that it has a local interface.");
            }
        }
        if (type == null) {
            type = component.getBeanClass();
        }
        if ((m = SeamComponentCallHelper.findMethod(methodName, type, params)) == null) {
            throw new RuntimeException("No compatible method found.");
        }
        try {
            Object result = m.invoke(seamComponent, params);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error calling method " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error calling method " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error calling method " + e.getMessage(), e);
        }
    }

    public static Object callSeamComponentByRef(Object seamRef, String methodName, Object[] params) {
        String seamName = SeamComponentCallHelper.getSeamComponentName(seamRef);
        return SeamComponentCallHelper.callSeamComponentByName(seamName, methodName, params);
    }

    public static Object callSeamComponentByRef(Object seamRef, String methodName, Object param) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(param);
        return SeamComponentCallHelper.callSeamComponentByRef(seamRef, methodName, params.toArray());
    }

    public static Object callSeamComponentByName(String seamName, String methodName, Object param) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(param);
        return SeamComponentCallHelper.callSeamComponentByName(seamName, methodName, params.toArray());
    }

    private static String getSeamComponentName(Object seamRef) {
        Name componentName = seamRef.getClass().getAnnotation(Name.class);
        if (componentName == null) {
            return null;
        }
        return componentName.value();
    }

    private static Method findMethod(String name, Class cls, Object[] params) {
        HashMap<Method, Integer> candidates = new HashMap<Method, Integer>();
        for (Method method : cls.getMethods()) {
            if (!name.equals(method.getName()) || method.getParameterTypes().length != params.length) continue;
            int score = 0;
            candidates.put(method, score);
        }
        Method bestMethod = null;
        int bestScore = 0;
        for (Method method : candidates.keySet()) {
            int thisScore = (Integer)candidates.get(method);
            if (bestMethod != null && thisScore <= bestScore) continue;
            bestMethod = method;
            bestScore = thisScore;
        }
        return bestMethod;
    }
}

