/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import com.google.common.collect.ImmutableSet;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.validator.BaseFacesObjectDescriptor;
import org.richfaces.validator.FacesValidatorDescriptor;
import org.richfaces.validator.MessageFactory;

public abstract class FacesServiceBase<T> {
    private static final ImmutableSet<String> HIDDEN_PROPERTIES = ImmutableSet.of((Object)"class", (Object)"transient");

    protected abstract String getMessageId(T var1);

    protected void fillParameters(BaseFacesObjectDescriptor<T> descriptor, T component) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(component.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                if (HIDDEN_PROPERTIES.contains((Object)name)) continue;
                try {
                    Object value;
                    Method readMethod = propertyDescriptor.getReadMethod();
                    if (readMethod == null || null == (value = readMethod.invoke(component, new Object[0]))) continue;
                    descriptor.addParameter(name, value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public FacesMessage getMessage(FacesContext context, T component, EditableValueHolder input, String msg) {
        if (null == msg) {
            String messageId = this.getMessageId(component);
            return MessageFactory.createMessage(context, messageId);
        }
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
    }

    protected void setLabelParameter(EditableValueHolder input, FacesValidatorDescriptor descriptor) {
        UIComponent component;
        Object label;
        if (input instanceof UIComponent && null != (label = (component = (UIComponent)input).getAttributes().get("label"))) {
            descriptor.addParameter("label", label);
        }
    }
}

