/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.faces.context.FacesContext;

public class JsfVersionInspector {
    String versionString;

    public JsfVersionInspector() {
        this.versionString = this.getPackageImplementationVersion();
        if (this.versionString == null) {
            this.versionString = this.getLogStringsImplementationVersion();
        }
        if (this.versionString == null) {
            this.versionString = this.getManifestImplementationVersion();
        }
    }

    JsfVersionInspector(String versionString) {
        this.versionString = versionString;
    }

    public boolean verifyJsfImplVersion() {
        if (this.isMojarra()) {
            Version version = this.parseVersion(this.versionString);
            return this.testVersion(version);
        }
        return true;
    }

    public String getVersionString() {
        return this.versionString;
    }

    boolean testVersion(Version version) {
        if (version.major < 2) {
            return false;
        }
        if (version.major > 2) {
            return true;
        }
        if (version.minor < 1) {
            return false;
        }
        if (version.minor == 1) {
            if (version.micro < 27) {
                return false;
            }
            if (version.micro == 27) {
                return version.qualifier.equals("redhat-9");
            }
            return true;
        }
        if (version.minor == 2) {
            if (version.micro < 5) {
                return false;
            }
            if (version.micro == 5) {
                return version.qualifier.equals("jbossorg-3");
            }
            return true;
        }
        return true;
    }

    String getPackageImplementationVersion() {
        Package facesPackage = FacesContext.getCurrentInstance().getClass().getPackage();
        return facesPackage.getImplementationVersion();
    }

    String getLogStringsImplementationVersion() {
        Properties prop = new Properties();
        InputStream in = this.getClass().getResourceAsStream("/com/sun/faces/LogStrings.properties");
        if (in == null) {
            return null;
        }
        try {
            prop.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load LogStrings.properties file to determine the mojarra version", e);
        }
        String jbossImplString = prop.getProperty("jsf.config.listener.version");
        return this.extractVersion(jbossImplString);
    }

    String getManifestImplementationVersion() {
        String manifestVersion = "";
        ZipFile jar = null;
        try {
            URL url = FacesContext.class.getProtectionDomain().getCodeSource().getLocation();
            jar = new JarFile(url.getFile());
            manifestVersion = ((JarFile)jar).getManifest().getMainAttributes().getValue("Implementation-version");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open a jar to determine the JSF version", e);
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return manifestVersion;
    }

    String extractVersion(String string) {
        Pattern pattern = Pattern.compile("([0-9][0-9\\.\\-a-z]*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        return "no match";
    }

    Version parseVersion(String versionString) {
        Version version;
        String qualifier;
        String[] numbers;
        if (versionString.matches("[0-9][0-9\\.]*\\-[a-zA-Z0-9\\-]*")) {
            String[] parts = versionString.split("-", 2);
            numbers = parts[0].split("\\.", 4);
            qualifier = parts[1];
        } else {
            numbers = versionString.split("\\.", 5);
            qualifier = numbers.length > 3 ? numbers[3] : "";
        }
        try {
            version = new Version(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), Integer.parseInt(numbers[2]), qualifier);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(MessageFormat.format("Error parsing detected JSF version string: {0} ", versionString), e);
        }
        return version;
    }

    boolean isMojarra() {
        String contextClassName = FacesContext.getCurrentInstance().getClass().getName();
        return "com.sun.faces.context.FacesContextImpl".equals(contextClassName) || "com.sun.faces.config.InitFacesContext".equals(contextClassName);
    }

    class Version {
        final int major;
        final int minor;
        final int micro;
        final String qualifier;

        private Version(int major, int minor, int micro, String qualifier) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.qualifier = qualifier;
        }
    }
}

