/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.server.jaxrs.AutomationResource;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@Path(value="/api/v1{repo : (/repo/[^/]+?)?}")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="APIRoot")
public class APIRoot
extends ModuleRoot {
    @Path(value="/")
    public Object doGetRepository(@PathParam(value="repo") String repositoryParam) throws NoSuchDocumentException {
        if (StringUtils.isNotBlank((String)repositoryParam)) {
            String repoName = repositoryParam.substring("repo/".length() + 1);
            try {
                this.ctx.setRepositoryName(repoName);
            }
            catch (ClientException e) {
                throw new WebResourceNotFoundException(e.getMessage());
            }
        }
        return this.newObject("repo", new Object[0]);
    }

    @Path(value="/user")
    public Object doGetUser() {
        return this.newObject("users", new Object[0]);
    }

    @Path(value="/group")
    public Object doGetGroup() {
        return this.newObject("groups", new Object[0]);
    }

    @Path(value="/automation")
    public Object getAutomationEndPoint() throws Exception {
        return new AutomationResource();
    }

    @Path(value="/directory")
    public Object doGetDirectory() {
        return this.newObject("directory", new Object[0]);
    }

    @Path(value="/doc")
    public Object doGetDocumentation() {
        return this.newObject("doc", new Object[0]);
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)"not authorized").type("text/plain").build();
        }
        if (e instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)e.getMessage()).type("text/plain").build();
        }
        return super.handleError(e);
    }
}

