/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import java.io.Serializable;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.AbstractUMRootObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="groups")
public class GroupRootObject
extends AbstractUMRootObject<NuxeoGroup> {
    public static final String PAGE_PROVIDER_NAME = "nuxeo_groups_listing";

    @Override
    protected NuxeoGroup getArtifact(String id) throws ClientException {
        return this.um.getGroup(id);
    }

    @Override
    protected String getArtifactType() {
        return "group";
    }

    @Override
    protected void checkPrecondition(NuxeoGroup group) throws ClientException {
        this.checkCurrentUserCanCreateArtifact(group);
        this.checkGroupHasAName(group);
        this.checkGroupDoesNotAlreadyExists(group, this.um);
    }

    @Override
    protected NuxeoGroup createArtifact(NuxeoGroup group) throws ClientException {
        DocumentModel groupModel = this.buildModelFromGroup(group, this.um);
        this.um.createGroup(groupModel);
        return this.um.getGroup(group.getName());
    }

    private DocumentModel buildModelFromGroup(NuxeoGroup group, UserManager um) throws ClientException {
        DocumentModel groupModel = um.getBareGroupModel();
        String schemaName = um.getGroupSchemaName();
        groupModel.setProperty(schemaName, um.getGroupIdField(), (Object)group.getName());
        groupModel.setProperty(schemaName, um.getGroupLabelField(), (Object)group.getLabel());
        groupModel.setPropertyValue(um.getGroupMembersField(), (Serializable)((Object)group.getMemberUsers()));
        groupModel.setPropertyValue(um.getGroupSubGroupsField(), (Serializable)((Object)group.getMemberGroups()));
        return groupModel;
    }

    private void checkGroupDoesNotAlreadyExists(NuxeoGroup group, UserManager um) throws ClientException {
        if (um.getGroup(group.getName()) != null) {
            throw new WebException("Group already exists", Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    private void checkGroupHasAName(NuxeoGroup group) {
        if (group.getName() == null) {
            throw new WebException("Group MUST have a name", Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Override
    boolean isAPowerUserEditableArtifact(NuxeoGroup artifact) {
        return GroupRootObject.isAPowerUserEditableGroup(artifact);
    }

    static boolean isAPowerUserEditableGroup(NuxeoGroup group) {
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        return !um.getAdministratorsGroups().contains(group.getName());
    }

    @Override
    protected PageProviderDefinition getPageProviderDefinition() {
        PageProviderService ppService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        return ppService.getPageProviderDefinition(PAGE_PROVIDER_NAME);
    }
}

